/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.customize.defaults;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.event.Event;
import org.rapidoid.event.Events;
import org.rapidoid.event.Fire;
import org.rapidoid.http.Req;
import org.rapidoid.http.customize.SessionManager;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class DefaultSessionManager
extends RapidoidThing
implements SessionManager {
    private final Map<String, SessionHolder> sessions = Coll.autoExpandingMap(String.class, SessionHolder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> loadSession(Req req, String sessionId) throws Exception {
        Fire.event((Event)Events.SESSION_LOAD, (String)"id", (Object)sessionId);
        SessionHolder holder = this.sessions.get(sessionId);
        if (holder.session == null) {
            SessionHolder sessionHolder = holder;
            synchronized (sessionHolder) {
                if (holder.session == null) {
                    if (holder.serialized != null) {
                        Fire.event((Event)Events.SESSION_DESERIALIZE, (String)"id", (Object)sessionId);
                        holder.session = (Map)U.cast((Object)Msc.deserialize((byte[])holder.serialized));
                    } else {
                        holder.session = Coll.concurrentMap();
                        Fire.event((Event)Events.SESSION_CONCURRENT_ACCESS, (String)"id", (Object)sessionId);
                    }
                }
            }
        }
        holder.refCounter.incrementAndGet();
        return holder.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveSession(Req req, String sessionId, Map<String, Serializable> session) throws Exception {
        Fire.event((Event)Events.SESSION_SAVE, (String)"id", (Object)sessionId);
        SessionHolder holder = this.sessions.get(sessionId);
        long refN = holder.refCounter.decrementAndGet();
        U.must((refN >= 0L ? 1 : 0) != 0, (String)"The session has negative reference counter!");
        if (refN == 0L) {
            SessionHolder sessionHolder = holder;
            synchronized (sessionHolder) {
                if (holder.refCounter.get() == 0L) {
                    Fire.event((Event)Events.SESSION_SERIALIZE, (String)"id", (Object)sessionId);
                    holder.serialized = Msc.serialize(session);
                    holder.session = null;
                }
            }
        }
    }

    public static class SessionHolder {
        volatile byte[] serialized;
        volatile Map<String, Serializable> session;
        final AtomicLong refCounter = new AtomicLong();
    }
}

