/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import java.util.Collections;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.UserInfo;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.HttpWrapper;
import org.rapidoid.http.Req;
import org.rapidoid.http.customize.Customization;
import org.rapidoid.http.handler.HandlerInvocation;
import org.rapidoid.security.Secure;
import org.rapidoid.u.U;
import org.rapidoid.util.TokenAuthData;

public class HttpAuthWrapper
extends RapidoidThing
implements HttpWrapper {
    private final Set<String> requiredRoles;

    public HttpAuthWrapper(Set<String> requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    @Override
    public Object wrap(Req req, HandlerInvocation invocation) throws Exception {
        Set scope;
        String username;
        TokenAuthData auth = HttpUtils.getAuth(req);
        String string = username = auth != null ? auth.user : null;
        if (U.isEmpty((String)username)) {
            HttpUtils.clearUserData(req);
        }
        Set<String> roles = this.userRoles(req, username);
        Set set = scope = auth != null ? auth.scope : null;
        if (U.notEmpty(this.requiredRoles) && !Secure.hasAnyRole((String)username, roles, this.requiredRoles)) {
            throw new SecurityException("The user doesn't have the required roles!");
        }
        Ctx ctx = Ctxs.required();
        ctx.setUser(new UserInfo(username, roles, scope));
        return invocation.invoke();
    }

    private Set<String> userRoles(Req req, String username) {
        if (username != null) {
            try {
                return Customization.of(req).rolesProvider().getRolesForUser(req, username);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        return Collections.emptySet();
    }
}

