/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.handler;

import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.Req;
import org.rapidoid.http.Resp;
import org.rapidoid.http.handler.AbstractDecoratingHttpHandler;
import org.rapidoid.http.handler.AbstractHttpHandlerDecorator;
import org.rapidoid.http.impl.MaybeReq;
import org.rapidoid.http.impl.ReqImpl;
import org.rapidoid.http.impl.lowlevel.HttpIO;
import org.rapidoid.log.Log;
import org.rapidoid.net.abstracts.Channel;

public class HttpUnmanagedHandlerDecorator
extends AbstractHttpHandlerDecorator {
    private final MediaType contentType;

    HttpUnmanagedHandlerDecorator(AbstractDecoratingHttpHandler handler, FastHttp http, MediaType contentType) {
        super(handler, http);
        this.contentType = contentType;
    }

    @Override
    public final HttpStatus handle(Channel ctx, boolean isKeepAlive, Req req) {
        int code;
        MediaType ctype;
        MaybeReq maybeReq = HttpUtils.maybe(req);
        ReqImpl reqq = (ReqImpl)req;
        Object result = this.handleReqAndPostProcess(ctx, isKeepAlive, req);
        if (req != null && reqq.hasResponseAttached()) {
            Resp resp = req.response();
            ctype = resp.contentType();
            code = resp.code();
        } else {
            ctype = this.contentType;
            code = 200;
        }
        if (result == HttpStatus.NOT_FOUND) {
            this.http.notFound(ctx, isKeepAlive, ctype, this.handler, req);
            return HttpStatus.NOT_FOUND;
        }
        if (result == HttpStatus.ASYNC) {
            return HttpStatus.ASYNC;
        }
        if (result instanceof Throwable) {
            Throwable err = (Throwable)result;
            HttpIO.INSTANCE.writeHttpResp(maybeReq, ctx, isKeepAlive, 500, MediaType.PLAIN_TEXT_UTF_8, "Internal server error!".getBytes());
            Log.error((String)"Error occurred during unmanaged request processing", (String)"request", (Object)req, (String)"error", (Object)err);
            return HttpStatus.DONE;
        }
        HttpIO.INSTANCE.writeHttpResp(maybeReq, ctx, isKeepAlive, code, ctype, result);
        return HttpStatus.DONE;
    }
}

