/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.impl;

import java.util.Date;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cache.Cache;
import org.rapidoid.cache.Caching;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.http.Route;
import org.rapidoid.http.RouteConfig;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.impl.CachedResp;
import org.rapidoid.http.impl.HTTPCacheKey;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.u.U;

public class RouteImpl
extends RapidoidThing
implements Route {
    private volatile HttpVerb verb;
    private volatile String path;
    private volatile HttpHandler handler;
    private volatile RouteOptions options;
    private volatile Date lastChangedAt = new Date();
    private final Cache<HTTPCacheKey, CachedResp> cache;

    public RouteImpl(HttpVerb verb, String path, HttpHandler handler, RouteOptions options) {
        this.verb = verb;
        this.path = path;
        this.handler = handler;
        this.options = options;
        this.cache = this.createCache();
    }

    public static RouteImpl matching(HttpVerb verb, String path) {
        return new RouteImpl(verb, path, null, null);
    }

    protected Cache<HTTPCacheKey, CachedResp> createCache() {
        if (this.options == null || this.options.cacheTTL() <= 0L) {
            return null;
        }
        return Caching.of(HTTPCacheKey.class, CachedResp.class).name(this.verb + " " + this.path).ttl(this.options.cacheTTL()).capacity(this.options.cacheCapacity()).manageable(true).statistics(true).build();
    }

    @Override
    public HttpVerb verb() {
        return this.verb;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public HttpHandler handler() {
        return this.handler;
    }

    @Override
    public RouteConfig config() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteImpl route = (RouteImpl)o;
        if (this.verb != route.verb) {
            return false;
        }
        return this.path.equals(route.path);
    }

    public String toString() {
        RouteConfig cfg = this.config();
        return U.frmt((String)"Route %s %s [zone %s] roles %s (TTL=%s) : %s", (Object[])new Object[]{this.verb, this.path, cfg.zone(), cfg.roles(), cfg.cacheTTL(), this.handler});
    }

    public int hashCode() {
        int result = this.verb.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public RouteImpl handler(HttpHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public Cache<HTTPCacheKey, CachedResp> cache() {
        return this.cache;
    }

    @Override
    public Date lastChangedAt() {
        return this.lastChangedAt;
    }
}

