/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.util.List;
import java.util.Set;
import org.rapidoid.RapidoidModule;
import org.rapidoid.RapidoidModules;
import org.rapidoid.beany.Beany;
import org.rapidoid.collection.Coll;
import org.rapidoid.config.Conf;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.data.JSON;
import org.rapidoid.env.Env;
import org.rapidoid.group.Groups;
import org.rapidoid.io.Res;
import org.rapidoid.ioc.Beans;
import org.rapidoid.ioc.IoC;
import org.rapidoid.ioc.IoCContext;
import org.rapidoid.log.Log;
import org.rapidoid.render.Templates;
import org.rapidoid.scan.ClasspathScanner;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.scan.Scan;
import org.rapidoid.setup.AppBootstrap;
import org.rapidoid.setup.AppRestartListener;
import org.rapidoid.setup.AppStarter;
import org.rapidoid.setup.AppStatus;
import org.rapidoid.setup.On;
import org.rapidoid.setup.ReloadUtil;
import org.rapidoid.setup.Setup;
import org.rapidoid.setup.SetupUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;

public class App
extends RapidoidInitializer {
    private static volatile String[] path;
    private static volatile String mainClassName;
    private static volatile String appPkgName;
    private static volatile boolean dirty;
    private static volatile boolean restarted;
    private static volatile AppStatus status;
    private static volatile AppBootstrap boot;
    private static final Set<Class<?>> invoked;
    static volatile ClassLoader loader;

    public static synchronized AppBootstrap init(String[] args, String ... extraArgs) {
        AppStarter.startUp(args, extraArgs);
        status = AppStatus.INITIALIZING;
        return App.boot();
    }

    public static synchronized AppBootstrap run(String[] args, String ... extraArgs) {
        AppStarter.startUp(args, extraArgs);
        App.boot();
        App.onAppReady();
        return App.boot();
    }

    public static synchronized AppBootstrap bootstrap(String[] args, String ... extraArgs) {
        AppStarter.startUp(args, extraArgs);
        App.boot().beans().services();
        App.onAppReady();
        return App.boot();
    }

    public static synchronized AppBootstrap boot() {
        if (boot == null) {
            boot = new AppBootstrap();
            for (RapidoidModule module : RapidoidModules.getAll()) {
                module.boot();
            }
        }
        return boot;
    }

    public static synchronized void profiles(String ... profiles) {
        Env.setProfiles((String[])profiles);
        Conf.reset();
    }

    public static void path(String ... path) {
        App.path = path;
    }

    public static synchronized String[] path() {
        App.inferCallers();
        if (path == null) {
            path = appPkgName != null ? (String[])U.array((Object[])new String[]{appPkgName}) : new String[]{};
        }
        return path;
    }

    static void inferCallers() {
        if (!Msc.isPlatform() && !restarted && appPkgName == null && mainClassName == null) {
            appPkgName = Msc.getCallingPackage((Class[])new Class[0]);
            if (mainClassName == null) {
                Class mainClass = Msc.getCallingMainClass();
                invoked.add(mainClass);
                String string = mainClassName = mainClass != null ? mainClass.getName() : null;
            }
            if (mainClassName != null || appPkgName != null) {
                Log.info((String)"Inferred application root", (String)"!main", (Object)mainClassName, (String)"!package", (Object)appPkgName);
            }
        }
    }

    private static synchronized void restartApp() {
        if (!MscOpts.hasRapidoidWatch()) {
            Log.warn((String)"Cannot reload/restart the application, module rapidoid-watch is missing!");
        }
        if (mainClassName == null) {
            Log.warn((String)"Cannot reload/restart the application, the main app class couldn't be detected!");
        }
        Msc.logSection((String)"!Restarting the web application...");
        restarted = true;
        App.notifyListenersBeforeRestart();
        App.resetAppStateBeforeRestart();
        if (MscOpts.hasRapidoidJPA()) {
            loader = ReloadUtil.reloader();
            ClasspathUtil.setDefaultClassLoader((ClassLoader)loader);
        }
        App.reloadAndRunMainClass();
        restarted = true;
        App.notifyListenersAfterRestart();
        Log.info((String)"!Successfully restarted the application!");
    }

    private static void notifyListenersAfterRestart() {
        Set listeners = U.set(On.changes().getRestartListeners());
        for (AppRestartListener listener : listeners) {
            try {
                listener.afterAppRestart();
            }
            catch (Exception e) {
                Log.error((String)"Error occurred in the app restart listener!", (Throwable)e);
            }
        }
    }

    private static void notifyListenersBeforeRestart() {
        Set listeners = U.set(On.changes().getRestartListeners());
        for (AppRestartListener listener : listeners) {
            try {
                listener.beforeAppRestart();
            }
            catch (Exception e) {
                Log.error((String)"Error occurred in the app restart listener!", (Throwable)e);
            }
        }
    }

    private static void reloadAndRunMainClass() {
        Class<?> entry;
        try {
            entry = loader.loadClass(mainClassName);
        }
        catch (ClassNotFoundException e) {
            Log.error((String)"Cannot restart the application, the main class (app entry point) is missing!");
            return;
        }
        Msc.invokeMain(entry, (String[])((String[])U.arrayOf(String.class, (Iterable)Env.args())));
    }

    private static void resetAppStateBeforeRestart() {
        path = null;
        boot = null;
        status = AppStatus.NOT_STARTED;
        dirty = false;
        Groups.reset();
        Conf.reset();
        Env.reset();
        Res.reset();
        Templates.reset();
        JSON.reset();
        Beany.reset();
        AppStarter.reset();
        AppBootstrap.reset();
        ClasspathScanner.reset();
        invoked.clear();
        SetupUtil.reloadAll();
        Conf.reset();
        Setup.initDefaults();
        Conf.reset();
    }

    public static synchronized void resetGlobalState() {
        status = AppStatus.NOT_STARTED;
        mainClassName = null;
        appPkgName = null;
        restarted = false;
        dirty = false;
        path = null;
        loader = App.class.getClassLoader();
        boot = null;
        Setup.initDefaults();
        AppStarter.reset();
        AppBootstrap.reset();
        invoked.clear();
    }

    static synchronized void notifyChanges() {
        if (!dirty) {
            dirty = true;
            Log.info((String)"Detected class or resource changes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean restartIfDirty() {
        if (!dirty || mainClassName == null) return false;
        Class<Setup> clazz = Setup.class;
        synchronized (Setup.class) {
            if (!dirty || mainClassName == null) return false;
            App.restartApp();
            dirty = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }

    static synchronized List<Class<?>> findBeans(String ... packages) {
        if (U.isEmpty((Object[])packages)) {
            packages = App.path();
        }
        return Scan.annotated((Class[])IoC.ANNOTATIONS).in(packages).loadAll();
    }

    public static synchronized boolean scan(String ... packages) {
        String appPath = (String)Conf.APP.entry("path").str().getOrNull();
        if (U.notEmpty((String)appPath)) {
            App.path(appPath);
        }
        List<Class<?>> beans = App.findBeans(packages);
        App.beans(beans.toArray());
        return !beans.isEmpty();
    }

    public static void beans(Object ... beans) {
        Setup.on().beans(beans);
    }

    public static IoCContext context() {
        return IoC.defaultContext();
    }

    static void filterAndInvokeMainClasses(Object[] beans) {
        Msc.filterAndInvokeMainClasses((Object[])beans, invoked);
    }

    static boolean isRestarted() {
        return restarted;
    }

    public static synchronized void register(Beans beans) {
        Setup.on().register(beans);
    }

    public static synchronized void shutdown() {
        status = AppStatus.STOPPING;
        Setup.shutdownAll();
        status = AppStatus.STOPPED;
    }

    public static synchronized void ready() {
        U.must((status == AppStatus.INITIALIZING ? 1 : 0) != 0, (String)"App.init() must be called before App.ready()!");
        App.onAppReady();
    }

    private static void onAppReady() {
        status = AppStatus.RUNNING;
        IoC.ready();
        Setup.ready();
        Log.info((String)"!Ready.");
    }

    public static AppStatus status() {
        return status;
    }

    static {
        status = AppStatus.NOT_STARTED;
        invoked = Coll.synchronizedSet((Object[])new Class[0]);
        loader = App.class.getClassLoader();
    }
}

