/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.jpa.JPA;
import org.rapidoid.setup.Admin;
import org.rapidoid.setup.App;
import org.rapidoid.setup.IGoodies;
import org.rapidoid.setup.On;
import org.rapidoid.setup.ServiceActivator;
import org.rapidoid.setup.ServiceBootstrap;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;

public class AppBootstrap
extends RapidoidThing {
    private static final ServiceBootstrap services = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            ServiceActivator.activateServices();
        }
    };
    private static final ServiceBootstrap jpa = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            if (MscOpts.hasJPA()) {
                JPA.bootstrap((String[])App.path(), (Class[])new Class[0]);
            }
        }
    };
    private static final ServiceBootstrap ping = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().ping(On.setup());
        }
    };
    private static final ServiceBootstrap auth = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().auth(On.setup());
        }
    };
    private static final ServiceBootstrap oauth = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().oauth(On.setup());
        }
    };
    private static final ServiceBootstrap entities = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().entities(Admin.setup());
        }
    };
    private static final ServiceBootstrap overview = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().overview(Admin.setup());
        }
    };
    private static final ServiceBootstrap application = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().application(Admin.setup());
        }
    };
    private static final ServiceBootstrap manageables = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().manageables(Admin.setup());
        }
    };
    private static final ServiceBootstrap lifecycle = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().lifecycle(Admin.setup());
        }
    };
    private static final ServiceBootstrap jmx = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().jmx(Admin.setup());
        }
    };
    private static final ServiceBootstrap metrics = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().metrics(Admin.setup());
        }
    };
    private static final ServiceBootstrap deploy = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().deploy(Admin.setup());
        }
    };
    private static final ServiceBootstrap status = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().status(Admin.setup());
        }
    };
    private static final ServiceBootstrap adminCenter = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            AppBootstrap.getGoodies().adminCenter(Admin.setup());
        }
    };
    private static final ServiceBootstrap beans = new ServiceBootstrap(){

        @Override
        protected void bootstrap() {
            App.scan(new String[0]);
        }
    };

    public AppBootstrap services() {
        services.run();
        return this;
    }

    public AppBootstrap jpa() {
        jpa.run();
        return this;
    }

    public AppBootstrap overview() {
        overview.run();
        return this;
    }

    public AppBootstrap application() {
        application.run();
        return this;
    }

    public AppBootstrap manageables() {
        manageables.run();
        return this;
    }

    public AppBootstrap lifecycle() {
        lifecycle.run();
        return this;
    }

    public AppBootstrap jmx() {
        jmx.run();
        return this;
    }

    public AppBootstrap metrics() {
        metrics.run();
        return this;
    }

    public AppBootstrap deploy() {
        deploy.run();
        return this;
    }

    public AppBootstrap status() {
        status.run();
        return this;
    }

    public AppBootstrap ping() {
        ping.run();
        return this;
    }

    public AppBootstrap auth() {
        auth.run();
        return this;
    }

    public AppBootstrap oauth() {
        oauth.run();
        return this;
    }

    public AppBootstrap adminCenter() {
        adminCenter.run();
        return this;
    }

    public AppBootstrap beans() {
        beans.run();
        return this;
    }

    static IGoodies getGoodies() {
        Class goodiesClass;
        if (Msc.isPlatform()) {
            goodiesClass = Cls.get((String)"org.rapidoid.goodies.RapidoidPlatformGoodies");
        } else {
            goodiesClass = Cls.getClassIfExists((String)"org.rapidoid.goodies.RapidoidGoodies");
            U.must((goodiesClass != null ? 1 : 0) != 0, (String)"Cannot find the Goodies, is module 'rapidoid-web' missing?");
        }
        return (IGoodies)Cls.newInstance((Class)goodiesClass);
    }

    public void full() {
        this.jpa();
        this.adminCenter();
        this.auth();
        this.oauth();
    }

    static void reset() {
        services.reset();
        jpa.reset();
        entities.reset();
        overview.reset();
        application.reset();
        manageables.reset();
        lifecycle.reset();
        jmx.reset();
        metrics.reset();
        deploy.reset();
        status.reset();
        ping.reset();
        auth.reset();
        oauth.reset();
        adminCenter.reset();
        beans.reset();
    }
}

