/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Err;
import org.rapidoid.http.FastHttp;
import org.rapidoid.http.HttpRoutes;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqHandler;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Resp;
import org.rapidoid.http.handler.HttpHandler;
import org.rapidoid.http.handler.MethodReqHandler;
import org.rapidoid.http.handler.PredefinedResponseHandler;
import org.rapidoid.http.handler.StaticHttpHandler;
import org.rapidoid.http.handler.lambda.FiveParamLambdaHandler;
import org.rapidoid.http.handler.lambda.FourParamLambdaHandler;
import org.rapidoid.http.handler.lambda.OneParamLambdaHandler;
import org.rapidoid.http.handler.lambda.SevenParamLambdaHandler;
import org.rapidoid.http.handler.lambda.SixParamLambdaHandler;
import org.rapidoid.http.handler.lambda.ThreeParamLambdaHandler;
import org.rapidoid.http.handler.lambda.TwoParamLambdaHandler;
import org.rapidoid.http.handler.optimized.CallableHttpHandler;
import org.rapidoid.http.handler.optimized.DelegatingParamsAwareReqHandler;
import org.rapidoid.http.handler.optimized.DelegatingParamsAwareReqRespHandler;
import org.rapidoid.http.handler.optimized.DelegatingParamsAwareRespHandler;
import org.rapidoid.http.impl.RouteOptions;
import org.rapidoid.lambda.FiveParamLambda;
import org.rapidoid.lambda.FourParamLambda;
import org.rapidoid.lambda.NParamLambda;
import org.rapidoid.lambda.OneParamLambda;
import org.rapidoid.lambda.SevenParamLambda;
import org.rapidoid.lambda.SixParamLambda;
import org.rapidoid.lambda.ThreeParamLambda;
import org.rapidoid.lambda.TwoParamLambda;
import org.rapidoid.setup.Setup;

class HttpHandlers
extends RapidoidThing {
    HttpHandlers() {
    }

    private static HttpHandler from(Setup setup, NParamLambda handler, RouteOptions options) {
        FastHttp http = setup.http();
        HttpRoutes routes = setup.routes();
        if (handler instanceof ReqHandler) {
            return new DelegatingParamsAwareReqHandler(http, routes, options, (OneParamLambda<?, ?>)((ReqHandler)handler));
        }
        if (handler instanceof ReqRespHandler) {
            return new DelegatingParamsAwareReqRespHandler(http, routes, options, (TwoParamLambda<?, ?, ?>)((ReqRespHandler)handler));
        }
        if (handler instanceof OneParamLambda) {
            OneParamLambda lambda = (OneParamLambda)handler;
            Method method = Cls.getLambdaMethod((Serializable)lambda);
            Class<?> paramType = method.getParameterTypes()[0];
            if (paramType.equals(Req.class)) {
                return new DelegatingParamsAwareReqHandler(http, routes, options, lambda);
            }
            if (paramType.equals(Resp.class)) {
                return new DelegatingParamsAwareRespHandler(http, routes, options, lambda);
            }
            return new OneParamLambdaHandler(http, routes, options, lambda);
        }
        if (handler instanceof TwoParamLambda) {
            TwoParamLambda lambda = (TwoParamLambda)handler;
            Method method = Cls.getLambdaMethod((Serializable)lambda);
            Class<?> param1Type = method.getParameterTypes()[0];
            Class<?> param2Type = method.getParameterTypes()[1];
            if (param1Type.equals(Req.class) && param2Type.equals(Resp.class)) {
                return new DelegatingParamsAwareReqRespHandler(http, routes, options, lambda);
            }
            return new TwoParamLambdaHandler(http, routes, options, (TwoParamLambda)handler);
        }
        if (handler instanceof ThreeParamLambda) {
            return new ThreeParamLambdaHandler(http, routes, options, (ThreeParamLambda)handler);
        }
        if (handler instanceof FourParamLambda) {
            return new FourParamLambdaHandler(http, routes, options, (FourParamLambda)handler);
        }
        if (handler instanceof FiveParamLambda) {
            return new FiveParamLambdaHandler(http, routes, options, (FiveParamLambda)handler);
        }
        if (handler instanceof SixParamLambda) {
            return new SixParamLambdaHandler(http, routes, options, (SixParamLambda)handler);
        }
        if (handler instanceof SevenParamLambda) {
            return new SevenParamLambdaHandler(http, routes, options, (SevenParamLambda)handler);
        }
        throw Err.notExpected();
    }

    static void registerStatic(Setup setup, String verb, String path, RouteOptions options, byte[] response) {
        setup.routes().on(verb, path, (HttpHandler)new StaticHttpHandler(options, response));
        setup.autoActivate();
    }

    static void registerPredefined(Setup setup, String verb, String path, RouteOptions options, Object response) {
        FastHttp http = setup.http();
        HttpRoutes routes = setup.routes();
        routes.on(verb, path, (HttpHandler)new PredefinedResponseHandler(http, routes, options, response));
        setup.autoActivate();
    }

    static void register(Setup setup, String verb, String path, RouteOptions options, Callable<?> handler) {
        FastHttp http = setup.http();
        HttpRoutes routes = setup.routes();
        routes.on(verb, path, (HttpHandler)new CallableHttpHandler(http, routes, options, handler));
        setup.autoActivate();
    }

    static void register(Setup setup, String verb, String path, RouteOptions options, NParamLambda lambda) {
        HttpHandler handler = HttpHandlers.from(setup, lambda, options);
        setup.routes().on(verb, path, handler);
        setup.autoActivate();
    }

    static void register(Setup setup, String verb, String path, RouteOptions options, Method method, Object instance) {
        FastHttp http = setup.http();
        HttpRoutes routes = setup.routes();
        routes.on(verb, path, (HttpHandler)new MethodReqHandler(http, routes, options, method, instance));
        setup.autoActivate();
    }
}

