/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.setup;

import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.env.Env;
import org.rapidoid.log.Log;
import org.rapidoid.setup.App;
import org.rapidoid.setup.AppRestartListener;
import org.rapidoid.setup.WatchForChanges;
import org.rapidoid.util.Msc;

public class OnChanges
extends RapidoidThing {
    static final OnChanges INSTANCE = new OnChanges();
    volatile boolean initialized;
    volatile boolean ignore;
    private final Set<AppRestartListener> restartListeners = Coll.synchronizedSet((Object[])new AppRestartListener[0]);

    private OnChanges() {
    }

    public synchronized void restart() {
        if (!this.initialized) {
            this.initialized = true;
            this.ignore = false;
            if (Env.dev()) {
                if (Msc.withWatchModule()) {
                    if (!Msc.isPlatform()) {
                        WatchForChanges.activate();
                    }
                } else {
                    Log.warn((String)"Cannot watch for class changes, the rapidoid-watch module is missing!");
                }
            } else {
                Log.warn((String)"Not running in dev mode, hot class reloading is disabled!");
            }
        }
    }

    public synchronized void byDefaultRestart() {
        if (!this.ignore) {
            this.restart();
        }
    }

    public synchronized void ignore() {
        this.ignore = true;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Set<AppRestartListener> getRestartListeners() {
        return this.restartListeners;
    }

    public void addRestartListener(AppRestartListener restartListener) {
        if (!App.isRestarted()) {
            this.restartListeners.add(restartListener);
        }
    }
}

