/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto.internal;

import java.util.Date;
import java.util.List;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.crypto.internal.AwsUtils;

public class HttpAwsQueryHelper
extends AuthenticatorHelper {
    public HttpAwsQueryHelper() {
        super(ChallengeScheme.HTTP_AWS_QUERY, true, false);
    }

    public Reference updateReference(Reference resourceRef, ChallengeResponse challengeResponse, Request request) {
        Reference result = resourceRef;
        Form query = result.getQueryAsForm();
        if (query.getFirst("Action") != null) {
            query.add("AWSAccessKeyId", new String(request.getChallengeResponse().getIdentifier()));
            query.add("SignatureMethod", "HmacSHA256");
            query.add("SignatureVersion", "2");
            query.add("Version", "2009-04-15");
            String df = DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_ISO_8601.get(0)));
            query.add("Timestamp", df);
            String signature = AwsUtils.getQuerySignature(request.getMethod(), request.getResourceRef(), (List<Parameter>)query, request.getChallengeResponse().getSecret());
            query.add("Signature", signature);
            result = new Reference(resourceRef);
            result.setQuery(query.getQueryString());
        }
        return result;
    }
}

