/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Protocol;
import org.restlet.engine.Edition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference {
    private static final boolean[] charValidityMap = new boolean[127];
    private volatile Reference baseRef;
    private volatile int fragmentIndex;
    private volatile String internalRef;
    private volatile int queryIndex;
    private volatile int schemeIndex;

    public static String decode(String toDecode) {
        String result = null;
        if (toDecode != null) {
            try {
                result = URLDecoder.decode(toDecode, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to decode the string with the UTF-8 character set.", uee);
            }
        }
        return result;
    }

    public static String decode(String toDecode, CharacterSet characterSet) {
        if (Edition.CURRENT == Edition.GWT && !CharacterSet.UTF_8.equals(characterSet)) {
            throw new IllegalArgumentException("Only UTF-8 URL encoding is supported under GWT");
        }
        String result = null;
        try {
            result = characterSet == null ? toDecode : URLDecoder.decode(toDecode, characterSet.getName());
        }
        catch (UnsupportedEncodingException uee) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to decode the string with the UTF-8 character set.", uee);
        }
        return result;
    }

    public static String encode(String toEncode) {
        String result = null;
        if (toEncode != null) {
            try {
                result = URLEncoder.encode(toEncode, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to encode the string with the UTF-8 character set.", uee);
            }
        }
        return result;
    }

    public static String encode(String toEncode, CharacterSet characterSet) {
        if (Edition.CURRENT == Edition.GWT && !CharacterSet.UTF_8.equals(characterSet)) {
            throw new IllegalArgumentException("Only UTF-8 URL encoding is supported under GWT");
        }
        String result = null;
        try {
            result = characterSet == null ? toEncode : URLEncoder.encode(toEncode, characterSet.getName());
        }
        catch (UnsupportedEncodingException uee) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to encode the string with the UTF-8 character set.", uee);
        }
        return result;
    }

    private static boolean isAlpha(int character) {
        return Reference.isUpperCase(character) || Reference.isLowerCase(character);
    }

    private static boolean isDigit(int character) {
        return character >= 48 && character <= 57;
    }

    public static boolean isGenericDelimiter(int character) {
        return character == 58 || character == 47 || character == 63 || character == 35 || character == 91 || character == 93 || character == 64;
    }

    private static boolean isLowerCase(int character) {
        return character >= 97 && character <= 122;
    }

    public static boolean isReserved(int character) {
        return Reference.isGenericDelimiter(character) || Reference.isSubDelimiter(character);
    }

    public static boolean isSubDelimiter(int character) {
        return character == 33 || character == 36 || character == 38 || character == 39 || character == 40 || character == 41 || character == 42 || character == 43 || character == 44 || character == 59 || character == 61;
    }

    public static boolean isUnreserved(int character) {
        return Reference.isAlpha(character) || Reference.isDigit(character) || character == 45 || character == 46 || character == 95 || character == 126;
    }

    private static boolean isUpperCase(int character) {
        return character >= 65 && character <= 90;
    }

    public static boolean isValid(int character) {
        return character >= 0 && character < 127 && charValidityMap[character];
    }

    public static String toString(String scheme, String hostName, Integer hostPort, String path, String query, String fragment) {
        String host = hostName;
        if (hostPort != null) {
            int defaultPort = Protocol.valueOf(scheme).getDefaultPort();
            if (hostPort != defaultPort) {
                host = hostName + ':' + hostPort;
            }
        }
        return Reference.toString(scheme, host, path, query, fragment);
    }

    public static String toString(String relativePart, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (relativePart != null) {
            sb.append(relativePart);
        }
        if (query != null) {
            sb.append('?').append(query);
        }
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
        return sb.toString();
    }

    public static String toString(String scheme, String host, String path, String query, String fragment) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            sb.append(scheme.toLowerCase()).append("://").append(host);
        }
        if (path != null) {
            sb.append(path);
        }
        if (query != null) {
            sb.append('?').append(query);
        }
        if (fragment != null) {
            sb.append('#').append(fragment);
        }
        return sb.toString();
    }

    public Reference() {
        this((Reference)null, (String)null);
    }

    public Reference(URI uri) {
        this(uri.toString());
    }

    public Reference(URL url) {
        this(url.toString());
    }

    public Reference(Protocol protocol, String hostName) {
        this(protocol, hostName, protocol.getDefaultPort());
    }

    public Reference(Protocol protocol, String hostName, int hostPort) {
        this(protocol.getSchemeName(), hostName, hostPort, null, null, null);
    }

    public Reference(Reference ref) {
        this(ref.baseRef, ref.internalRef);
    }

    public Reference(Reference baseRef, Reference uriReference) {
        this(baseRef, uriReference.toString());
    }

    public Reference(Reference baseRef, String uriRef) {
        uriRef = this.encodeInvalidCharacters(uriRef);
        this.baseRef = baseRef;
        this.internalRef = uriRef;
        this.updateIndexes();
    }

    public Reference(Reference baseRef, String relativePart, String query, String fragment) {
        this(baseRef, Reference.toString(relativePart, query, fragment));
    }

    public Reference(String uriReference) {
        this((Reference)null, uriReference);
    }

    public Reference(String identifier, String fragment) {
        this(fragment == null ? identifier : identifier + '#' + fragment);
    }

    public Reference(String scheme, String hostName, int hostPort, String path, String query, String fragment) {
        this(Reference.toString(scheme, hostName, hostPort, path, query, fragment));
    }

    public Reference addQueryParameter(String name, String value) {
        String query = this.getQuery();
        if (query == null) {
            if (value == null) {
                this.setQuery(Reference.encode(name));
            } else {
                this.setQuery(Reference.encode(name) + '=' + Reference.encode(value));
            }
        } else if (value == null) {
            this.setQuery(query + '&' + Reference.encode(name));
        } else {
            this.setQuery(query + '&' + Reference.encode(name) + '=' + Reference.encode(value));
        }
        return this;
    }

    public Reference addSegment(String value) {
        String path = this.getPath();
        if (value != null) {
            if (path == null) {
                this.setPath("/" + value);
            } else if (path.endsWith("/")) {
                this.setPath(path + Reference.encode(value));
            } else {
                this.setPath(path + "/" + Reference.encode(value));
            }
        }
        return this;
    }

    public Reference clone() {
        Reference newRef = new Reference();
        newRef.baseRef = this.baseRef == null ? null : (this.equals(this.baseRef) ? newRef : this.baseRef.clone());
        newRef.fragmentIndex = this.fragmentIndex;
        newRef.internalRef = this.internalRef;
        newRef.queryIndex = this.queryIndex;
        newRef.schemeIndex = this.schemeIndex;
        return newRef;
    }

    private String encodeInvalidCharacters(String uriRef) throws IllegalArgumentException {
        String result = uriRef;
        if (uriRef != null) {
            boolean valid = true;
            for (int i = 0; valid && i < uriRef.length(); ++i) {
                if (!Reference.isValid(uriRef.charAt(i))) {
                    valid = false;
                    Context.getCurrentLogger().fine("Invalid character detected in URI reference at index '" + i + "': \"" + uriRef.charAt(i) + "\". It will be automatically encoded.");
                    continue;
                }
                if (uriRef.charAt(i) != '%' || i <= uriRef.length() - 2) continue;
                valid = false;
                Context.getCurrentLogger().fine("Invalid percent encoding detected in URI reference at index '" + i + "': \"" + uriRef.charAt(i) + "\". It will be automatically encoded.");
            }
            if (!valid) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < uriRef.length(); ++i) {
                    if (Reference.isValid(uriRef.charAt(i))) {
                        if (uriRef.charAt(i) == '%' && i > uriRef.length() - 2) {
                            sb.append("%25");
                            continue;
                        }
                        sb.append(uriRef.charAt(i));
                        continue;
                    }
                    sb.append(Reference.encode(String.valueOf(uriRef.charAt(i))));
                }
                result = sb.toString();
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof Reference) {
            Reference ref = (Reference)object;
            if (this.internalRef == null) {
                return ref.internalRef == null;
            }
            return this.internalRef.equals(ref.internalRef);
        }
        return false;
    }

    public String getAuthority() {
        String part;
        String string = part = this.isRelative() ? this.getRelativePart() : this.getSchemeSpecificPart();
        if (part != null && part.startsWith("//")) {
            int index = part.indexOf(47, 2);
            if (index != -1) {
                return part.substring(2, index);
            }
            index = part.indexOf(63);
            if (index != -1) {
                return part.substring(2, index);
            }
            return part.substring(2);
        }
        return null;
    }

    public String getAuthority(boolean decode) {
        return decode ? Reference.decode(this.getAuthority()) : this.getAuthority();
    }

    public Reference getBaseRef() {
        return this.baseRef;
    }

    public String getExtensions() {
        String result = null;
        String lastSegment = this.getLastSegment();
        if (lastSegment != null) {
            int extensionIndex = lastSegment.indexOf(46);
            int matrixIndex = lastSegment.indexOf(59);
            if (extensionIndex != -1) {
                result = matrixIndex != -1 ? lastSegment.substring(extensionIndex + 1, matrixIndex) : lastSegment.substring(extensionIndex + 1);
            }
        }
        return result;
    }

    public String[] getExtensionsAsArray() {
        String[] result = null;
        String extensions = this.getExtensions();
        if (extensions != null) {
            result = extensions.split("\\.");
        }
        return result;
    }

    public String getFragment() {
        if (this.hasFragment()) {
            return this.internalRef.substring(this.fragmentIndex + 1);
        }
        return null;
    }

    public String getFragment(boolean decode) {
        return decode ? Reference.decode(this.getFragment()) : this.getFragment();
    }

    public String getHierarchicalPart() {
        if (this.hasScheme()) {
            if (this.hasQuery()) {
                return this.internalRef.substring(this.schemeIndex + 1, this.queryIndex);
            }
            if (this.hasFragment()) {
                return this.internalRef.substring(this.schemeIndex + 1, this.fragmentIndex);
            }
            return this.internalRef.substring(this.schemeIndex + 1);
        }
        if (this.hasQuery()) {
            return this.internalRef.substring(0, this.queryIndex);
        }
        if (this.hasFragment()) {
            return this.internalRef.substring(0, this.fragmentIndex);
        }
        return this.internalRef;
    }

    public String getHierarchicalPart(boolean decode) {
        return decode ? Reference.decode(this.getHierarchicalPart()) : this.getHierarchicalPart();
    }

    public String getHostDomain() {
        String result = null;
        String authority = this.getAuthority();
        if (authority != null) {
            int index1 = authority.indexOf(64);
            int index2 = authority.indexOf(58, index1 == -1 ? 0 : index1);
            result = index1 != -1 ? (index2 != -1 ? authority.substring(index1 + 1, index2) : authority.substring(index1 + 1)) : (index2 != -1 ? authority.substring(0, index2) : authority);
        }
        return result;
    }

    public String getHostDomain(boolean decode) {
        return decode ? Reference.decode(this.getHostDomain()) : this.getHostDomain();
    }

    public String getHostIdentifier() {
        StringBuilder result = new StringBuilder();
        result.append(this.getScheme()).append("://").append(this.getAuthority());
        return result.toString();
    }

    public String getHostIdentifier(boolean decode) {
        return decode ? Reference.decode(this.getHostIdentifier()) : this.getHostIdentifier();
    }

    public int getHostPort() {
        int index1;
        int index;
        int result = -1;
        String authority = this.getAuthority();
        if (authority != null && (index = authority.indexOf(58, (index1 = authority.indexOf(64)) == -1 ? 0 : index1)) != -1) {
            try {
                result = Integer.parseInt(authority.substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                Context.getCurrentLogger().log(Level.WARNING, "Can't parse hostPort : [hostRef,requestUri]=[" + this.getBaseRef() + "," + this.internalRef + "]");
            }
        }
        return result;
    }

    public String getIdentifier() {
        if (this.hasFragment()) {
            return this.internalRef.substring(0, this.fragmentIndex);
        }
        return this.internalRef;
    }

    public String getIdentifier(boolean decode) {
        return decode ? Reference.decode(this.getIdentifier()) : this.getIdentifier();
    }

    public String getLastSegment() {
        String result = null;
        String path = this.getPath();
        if (path != null) {
            int lastSlash;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if ((lastSlash = path.lastIndexOf(47)) != -1) {
                result = path.substring(lastSlash + 1);
            }
        }
        return result;
    }

    public String getLastSegment(boolean decode) {
        return this.getLastSegment(decode, false);
    }

    public String getLastSegment(boolean decode, boolean excludeMatrix) {
        int matrixIndex;
        String result = this.getLastSegment();
        if (excludeMatrix && result != null && (matrixIndex = result.indexOf(59)) != -1) {
            result = result.substring(0, matrixIndex);
        }
        return decode ? Reference.decode(result) : result;
    }

    public String getMatrix() {
        int matrixIndex;
        String lastSegment = this.getLastSegment();
        if (lastSegment != null && (matrixIndex = lastSegment.indexOf(59)) != -1) {
            return lastSegment.substring(matrixIndex + 1);
        }
        return null;
    }

    public String getMatrix(boolean decode) {
        return decode ? Reference.decode(this.getMatrix()) : this.getMatrix();
    }

    public Form getMatrixAsForm() {
        return new Form(this.getMatrix(), ';');
    }

    public Form getMatrixAsForm(CharacterSet characterSet) {
        return new Form(this.getMatrix(), characterSet, ';');
    }

    public Reference getParentRef() {
        Reference result = null;
        if (this.isHierarchical()) {
            String parentRef = null;
            String path = this.getPath();
            if (!path.equals("/") && !path.equals("")) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                parentRef = this.getHostIdentifier() + path.substring(0, path.lastIndexOf(47) + 1);
            } else {
                parentRef = this.internalRef;
            }
            result = new Reference(parentRef);
        }
        return result;
    }

    public String getPath() {
        String part;
        String result = null;
        String string = part = this.isRelative() ? this.getRelativePart() : this.getSchemeSpecificPart();
        if (part != null) {
            if (part.startsWith("//")) {
                int index1 = part.indexOf(47, 2);
                if (index1 != -1) {
                    int index2 = part.indexOf(63);
                    result = index2 != -1 ? part.substring(index1, index2) : part.substring(index1);
                }
            } else {
                int index = part.indexOf(63);
                result = index != -1 ? part.substring(0, index) : part;
            }
        }
        return result;
    }

    public String getPath(boolean decode) {
        return decode ? Reference.decode(this.getPath()) : this.getPath();
    }

    public String getQuery() {
        if (this.hasQuery()) {
            if (this.hasFragment()) {
                if (this.queryIndex < this.fragmentIndex) {
                    return this.internalRef.substring(this.queryIndex + 1, this.fragmentIndex);
                }
                return null;
            }
            return this.internalRef.substring(this.queryIndex + 1);
        }
        return null;
    }

    public String getQuery(boolean decode) {
        return decode ? Reference.decode(this.getQuery()) : this.getQuery();
    }

    public Form getQueryAsForm() {
        return new Form(this.getQuery());
    }

    public Form getQueryAsForm(CharacterSet characterSet) {
        return new Form(this.getQuery(), characterSet);
    }

    public String getRelativePart() {
        return this.isRelative() ? this.toString(false, false) : null;
    }

    public String getRelativePart(boolean decode) {
        return decode ? Reference.decode(this.getRelativePart()) : this.getRelativePart();
    }

    public Reference getRelativeRef() {
        return this.getRelativeRef(this.getBaseRef());
    }

    public Reference getRelativeRef(Reference base) {
        Reference result = null;
        if (base == null) {
            result = this;
        } else {
            if (!this.isAbsolute() || !this.isHierarchical()) {
                throw new IllegalArgumentException("The reference must have an absolute hierarchical path component");
            }
            if (!base.isAbsolute() || !base.isHierarchical()) {
                throw new IllegalArgumentException("The base reference must have an absolute hierarchical path component");
            }
            if (!this.getHostIdentifier().equals(base.getHostIdentifier())) {
                result = this;
            } else {
                String localPath = this.getPath();
                String basePath = base.getPath();
                String relativePath = null;
                if (basePath == null || localPath == null) {
                    relativePath = localPath;
                } else {
                    boolean diffFound = false;
                    int lastSlashIndex = -1;
                    int i = 0;
                    while (!diffFound && i < localPath.length() && i < basePath.length()) {
                        char current = localPath.charAt(i);
                        if (current != basePath.charAt(i)) {
                            diffFound = true;
                            continue;
                        }
                        if (current == '/') {
                            lastSlashIndex = i;
                        }
                        ++i;
                    }
                    if (!diffFound) {
                        if (localPath.length() == basePath.length()) {
                            relativePath = ".";
                        } else if (i == localPath.length()) {
                            if (basePath.charAt(i) == '/') {
                                if (i + 1 == basePath.length()) {
                                    relativePath = ".";
                                } else {
                                    StringBuilder sb = new StringBuilder();
                                    int segments = 0;
                                    int j = basePath.indexOf(47, i);
                                    while (j != -1) {
                                        ++segments;
                                        j = basePath.indexOf(47, j + 1);
                                    }
                                    for (j = 0; j < segments; ++j) {
                                        sb.append("../");
                                    }
                                    int lastLocalSlash = localPath.lastIndexOf(47);
                                    sb.append(localPath.substring(lastLocalSlash + 1));
                                    relativePath = sb.toString();
                                }
                            } else {
                                StringBuilder sb = new StringBuilder();
                                int segments = 0;
                                int j = basePath.indexOf(47, i);
                                while (j != -1) {
                                    ++segments;
                                    j = basePath.indexOf(47, j + 1);
                                }
                                for (j = 0; j < segments; ++j) {
                                    if (j > 0) {
                                        sb.append("/..");
                                        continue;
                                    }
                                    sb.append("..");
                                }
                                relativePath = sb.toString();
                                if (relativePath.equals("")) {
                                    relativePath = ".";
                                }
                            }
                        } else if (i == basePath.length()) {
                            relativePath = localPath.charAt(i) == '/' ? (i + 1 == localPath.length() ? "." : localPath.substring(i + 1)) : (lastSlashIndex == i - 1 ? localPath.substring(i) : ".." + localPath.substring(lastSlashIndex));
                        }
                    } else {
                        StringBuilder sb = new StringBuilder();
                        int segments = 0;
                        int j = basePath.indexOf(47, i);
                        while (j != -1) {
                            ++segments;
                            j = basePath.indexOf(47, j + 1);
                        }
                        for (j = 0; j < segments; ++j) {
                            sb.append("../");
                        }
                        sb.append(localPath.substring(lastSlashIndex + 1));
                        relativePath = sb.toString();
                    }
                }
                result = new Reference();
                String query = this.getQuery();
                String fragment = this.getFragment();
                boolean modified = false;
                if (query != null && !query.equals(base.getQuery())) {
                    result.setQuery(query);
                    modified = true;
                }
                if (fragment != null && !fragment.equals(base.getFragment())) {
                    result.setFragment(fragment);
                    modified = true;
                }
                if (!modified || !relativePath.equals(".")) {
                    result.setPath(relativePath);
                }
            }
        }
        return result;
    }

    public String getRemainingPart() {
        return this.getRemainingPart(false, true);
    }

    public String getRemainingPart(boolean decode) {
        return this.getRemainingPart(true, true);
    }

    public String getRemainingPart(boolean decode, boolean query) {
        String result = null;
        String all = this.toString(query, false);
        if (this.getBaseRef() != null) {
            String base = this.getBaseRef().toString(query, false);
            if (base != null && all.startsWith(base)) {
                result = all.substring(base.length());
            }
        } else {
            result = all;
        }
        return decode ? Reference.decode(result) : result;
    }

    public String getScheme() {
        if (this.hasScheme()) {
            return this.internalRef.substring(0, this.schemeIndex);
        }
        return null;
    }

    public String getScheme(boolean decode) {
        return decode ? Reference.decode(this.getScheme()) : this.getScheme();
    }

    public Protocol getSchemeProtocol() {
        return Protocol.valueOf(this.getScheme());
    }

    public String getSchemeSpecificPart() {
        String result = null;
        if (this.hasScheme()) {
            result = this.hasFragment() ? this.internalRef.substring(this.schemeIndex + 1, this.fragmentIndex) : this.internalRef.substring(this.schemeIndex + 1);
        }
        return result;
    }

    public String getSchemeSpecificPart(boolean decode) {
        return decode ? Reference.decode(this.getSchemeSpecificPart()) : this.getSchemeSpecificPart();
    }

    public List<String> getSegments() {
        ArrayList<String> result = new ArrayList<String>();
        String path = this.getPath();
        int start = -2;
        if (path != null) {
            for (int i = 0; i < path.length(); ++i) {
                char current = path.charAt(i);
                if (current == '/') {
                    if (start == -2) {
                        start = i;
                        continue;
                    }
                    result.add(path.substring(start + 1, i));
                    start = i;
                    continue;
                }
                if (start != -2) continue;
                start = -1;
            }
            if (start != -2) {
                result.add(path.substring(start + 1));
            }
        }
        return result;
    }

    public List<String> getSegments(boolean decode) {
        List<String> result = this.getSegments();
        if (decode) {
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, Reference.decode(result.get(i)));
            }
        }
        return result;
    }

    public Reference getTargetRef() {
        Reference result = null;
        if (this.isRelative() && this.baseRef != null) {
            Reference baseReference = null;
            baseReference = this.baseRef.isAbsolute() ? this.baseRef : this.baseRef.getTargetRef();
            if (baseReference.isRelative()) {
                throw new IllegalArgumentException("The base reference must have an absolute hierarchical path component");
            }
            String authority = this.getAuthority();
            String path = this.getPath();
            String query = this.getQuery();
            String fragment = this.getFragment();
            result = new Reference();
            result.setScheme(baseReference.getScheme());
            if (authority != null) {
                result.setAuthority(authority);
                result.setPath(path);
                result.setQuery(query);
            } else {
                result.setAuthority(baseReference.getAuthority());
                if (path == null || path.equals("")) {
                    result.setPath(baseReference.getPath());
                    if (query != null) {
                        result.setQuery(query);
                    } else {
                        result.setQuery(baseReference.getQuery());
                    }
                } else {
                    if (path.startsWith("/")) {
                        result.setPath(path);
                    } else {
                        int lastSlash;
                        String basePath = baseReference.getPath();
                        String mergedPath = null;
                        mergedPath = baseReference.getAuthority() != null && (basePath == null || basePath.equals("")) ? "/" + path : ((lastSlash = basePath.lastIndexOf(47)) == -1 ? path : basePath.substring(0, lastSlash + 1) + path);
                        result.setPath(mergedPath);
                    }
                    result.setQuery(query);
                }
            }
            result.setFragment(fragment);
        } else {
            if (this.isRelative()) {
                throw new IllegalArgumentException("Relative references are only usable when a base reference is set.");
            }
            result = new Reference(this.internalRef);
        }
        result.normalize();
        return result;
    }

    public String getUserInfo() {
        int index;
        String result = null;
        String authority = this.getAuthority();
        if (authority != null && (index = authority.indexOf(64)) != -1) {
            result = authority.substring(0, index);
        }
        return result;
    }

    public String getUserInfo(boolean decode) {
        return decode ? Reference.decode(this.getUserInfo()) : this.getUserInfo();
    }

    public boolean hasExtensions() {
        String lastSegment;
        boolean result = false;
        String path = this.getPath();
        if (!(path != null && path.endsWith("/") || (lastSegment = this.getLastSegment()) == null)) {
            int extensionsIndex = lastSegment.indexOf(46);
            int matrixIndex = lastSegment.indexOf(59);
            result = extensionsIndex != -1 && (matrixIndex == -1 || extensionsIndex < matrixIndex);
        }
        return result;
    }

    public boolean hasFragment() {
        return this.fragmentIndex != -1;
    }

    public int hashCode() {
        return this.internalRef == null ? 0 : this.internalRef.hashCode();
    }

    public boolean hasMatrix() {
        return this.getLastSegment().indexOf(59) != -1;
    }

    public boolean hasQuery() {
        return this.queryIndex != -1;
    }

    public boolean hasScheme() {
        return this.schemeIndex != -1;
    }

    public boolean isAbsolute() {
        return this.getScheme() != null;
    }

    public boolean isEquivalentTo(Reference ref) {
        return this.getTargetRef().equals(ref.getTargetRef());
    }

    public boolean isHierarchical() {
        return this.isRelative() || this.getSchemeSpecificPart().charAt(0) == '/';
    }

    public boolean isOpaque() {
        return this.isAbsolute() && this.getSchemeSpecificPart().charAt(0) != '/';
    }

    public boolean isParent(Reference childRef) {
        boolean result = false;
        if (childRef != null && childRef.isHierarchical()) {
            result = childRef.toString(false, false).startsWith(this.toString(false, false));
        }
        return result;
    }

    public boolean isRelative() {
        return this.getScheme() == null;
    }

    public Reference normalize() {
        int defaultPort;
        StringBuilder output = new StringBuilder();
        StringBuilder input = new StringBuilder();
        String path = this.getPath();
        if (path != null) {
            input.append(path);
        }
        while (input.length() > 0) {
            if (input.length() >= 3 && input.substring(0, 3).equals("../")) {
                input.delete(0, 3);
                continue;
            }
            if (input.length() >= 2 && input.substring(0, 2).equals("./")) {
                input.delete(0, 2);
                continue;
            }
            if (input.length() >= 3 && input.substring(0, 3).equals("/./")) {
                input.delete(0, 2);
                continue;
            }
            if (input.length() == 2 && input.substring(0, 2).equals("/.")) {
                input.delete(1, 2);
                continue;
            }
            if (input.length() >= 4 && input.substring(0, 4).equals("/../")) {
                input.delete(0, 3);
                this.removeLastSegment(output);
                continue;
            }
            if (input.length() == 3 && input.substring(0, 3).equals("/..")) {
                input.delete(1, 3);
                this.removeLastSegment(output);
                continue;
            }
            if (input.length() == 1 && input.substring(0, 1).equals(".")) {
                input.delete(0, 1);
                continue;
            }
            if (input.length() == 2 && input.substring(0, 2).equals("..")) {
                input.delete(0, 2);
                continue;
            }
            int max = -1;
            for (int i = 1; max == -1 && i < input.length(); ++i) {
                if (input.charAt(i) != '/') continue;
                max = i;
            }
            if (max != -1) {
                output.append(input.substring(0, max));
                input.delete(0, max);
                continue;
            }
            output.append((CharSequence)input);
            input.delete(0, input.length());
        }
        this.setPath(output.toString());
        this.setScheme(this.getScheme());
        this.setHostDomain(this.getHostDomain());
        int hostPort = this.getHostPort();
        if (hostPort != -1 && hostPort == (defaultPort = Protocol.valueOf(this.getScheme()).getDefaultPort())) {
            this.setHostPort(null);
        }
        return this;
    }

    private void removeLastSegment(StringBuilder output) {
        int min = -1;
        for (int i = output.length() - 1; min == -1 && i >= 0; --i) {
            if (output.charAt(i) != '/') continue;
            min = i;
        }
        if (min != -1) {
            output.delete(min, output.length());
        } else {
            output.delete(0, output.length());
        }
    }

    public void setAuthority(String authority) {
        int index;
        String newAuthority;
        String oldPart = this.isRelative() ? this.getRelativePart() : this.getSchemeSpecificPart();
        String string = newAuthority = authority == null ? "" : "//" + authority;
        String newPart = oldPart == null ? newAuthority : (oldPart.startsWith("//") ? ((index = oldPart.indexOf(47, 2)) != -1 ? newAuthority + oldPart.substring(index) : ((index = oldPart.indexOf(63)) != -1 ? newAuthority + oldPart.substring(index) : newAuthority)) : newAuthority + oldPart);
        if (this.isAbsolute()) {
            this.setSchemeSpecificPart(newPart);
        } else {
            this.setRelativePart(newPart);
        }
    }

    public void setBaseRef(Reference baseRef) {
        this.baseRef = baseRef;
    }

    public void setBaseRef(String baseUri) {
        this.setBaseRef(new Reference(baseUri));
    }

    public void setExtensions(String extensions) {
        String lastSegment = this.getLastSegment();
        if (lastSegment != null) {
            int extensionIndex = lastSegment.indexOf(46);
            int matrixIndex = lastSegment.indexOf(59);
            StringBuilder sb = new StringBuilder();
            if (extensionIndex != -1) {
                sb.append(lastSegment.substring(0, extensionIndex));
                if (extensions != null && extensions.length() > 0) {
                    sb.append('.').append(extensions);
                }
                if (matrixIndex != -1) {
                    sb.append(lastSegment.substring(matrixIndex));
                }
            } else if (extensions != null && extensions.length() > 0) {
                if (matrixIndex != -1) {
                    sb.append(lastSegment.substring(0, matrixIndex)).append('.').append(extensions).append(lastSegment.substring(matrixIndex));
                } else {
                    sb.append(lastSegment).append('.').append(extensions);
                }
            } else {
                sb.append(lastSegment);
            }
            this.setLastSegment(sb.toString());
        } else {
            this.setLastSegment('.' + extensions);
        }
    }

    public void setExtensions(String[] extensions) {
        String exts = null;
        if (extensions != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < extensions.length; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(extensions[i]);
            }
            exts = sb.toString();
        }
        this.setExtensions(exts);
    }

    public void setFragment(String fragment) {
        if ((fragment = this.encodeInvalidCharacters(fragment)) != null && fragment.indexOf(35) != -1) {
            throw new IllegalArgumentException("Illegal '#' character detected in parameter");
        }
        if (this.hasFragment()) {
            this.internalRef = fragment != null ? this.internalRef.substring(0, this.fragmentIndex + 1) + fragment : this.internalRef.substring(0, this.fragmentIndex);
        } else if (fragment != null) {
            this.internalRef = this.internalRef != null ? this.internalRef + '#' + fragment : '#' + fragment;
        }
        this.updateIndexes();
    }

    public void setHostDomain(String domain) {
        String authority = this.getAuthority();
        if (authority == null) {
            this.setAuthority(domain);
        } else {
            domain = domain == null ? "" : domain.toLowerCase();
            int index1 = authority.indexOf(64);
            int index2 = authority.indexOf(58, index1 == -1 ? 0 : index1);
            if (index1 != -1) {
                if (index2 != -1) {
                    this.setAuthority(authority.substring(0, index1 + 1) + domain + authority.substring(index2));
                } else {
                    this.setAuthority(authority.substring(0, index1 + 1) + domain);
                }
            } else if (index2 != -1) {
                this.setAuthority(domain + authority.substring(index2));
            } else {
                this.setAuthority(domain);
            }
        }
    }

    public void setHostPort(Integer port) {
        String authority = this.getAuthority();
        if (authority != null) {
            String newPort;
            int index1 = authority.indexOf(64);
            int index = authority.indexOf(58, index1 == -1 ? 0 : index1);
            String string = newPort = port == null ? "" : ":" + port;
            if (index != -1) {
                this.setAuthority(authority.substring(0, index) + newPort);
            } else {
                this.setAuthority(authority + newPort);
            }
        } else {
            throw new IllegalArgumentException("No authority defined, please define a host name first");
        }
    }

    public void setIdentifier(String identifier) {
        if ((identifier = this.encodeInvalidCharacters(identifier)) == null) {
            identifier = "";
        }
        if (identifier.indexOf(35) != -1) {
            throw new IllegalArgumentException("Illegal '#' character detected in parameter");
        }
        this.internalRef = this.hasFragment() ? identifier + this.internalRef.substring(this.fragmentIndex) : identifier;
        this.updateIndexes();
    }

    public void setLastSegment(String lastSegment) {
        String path = this.getPath();
        int lastSlashIndex = path.lastIndexOf(47);
        if (lastSlashIndex != -1) {
            this.setPath(path.substring(0, lastSlashIndex + 1) + lastSegment);
        } else {
            this.setPath('/' + lastSegment);
        }
    }

    public void setPath(String path) {
        String oldPart = this.isRelative() ? this.getRelativePart() : this.getSchemeSpecificPart();
        String newPart = null;
        if (oldPart != null) {
            int index;
            int index2;
            int index1;
            if (path == null) {
                path = "";
            }
            newPart = oldPart.startsWith("//") ? ((index1 = oldPart.indexOf(47, 2)) != -1 ? ((index2 = oldPart.indexOf(63)) != -1 ? oldPart.substring(0, index1) + path + oldPart.substring(index2) : oldPart.substring(0, index1) + path) : ((index2 = oldPart.indexOf(63)) != -1 ? oldPart.substring(0, index2) + path + oldPart.substring(index2) : oldPart + path)) : ((index = oldPart.indexOf(63)) != -1 ? path + oldPart.substring(index) : path);
        } else {
            newPart = path;
        }
        if (this.isAbsolute()) {
            this.setSchemeSpecificPart(newPart);
        } else {
            this.setRelativePart(newPart);
        }
    }

    public void setProtocol(Protocol protocol) {
        this.setScheme(protocol.getSchemeName());
    }

    public void setQuery(String query) {
        boolean emptyQueryString;
        boolean bl = emptyQueryString = (query = this.encodeInvalidCharacters(query)) == null || query.length() <= 0;
        if (this.hasQuery()) {
            this.internalRef = this.hasFragment() ? (!emptyQueryString ? this.internalRef.substring(0, this.queryIndex + 1) + query + this.internalRef.substring(this.fragmentIndex) : this.internalRef.substring(0, this.queryIndex) + this.internalRef.substring(this.fragmentIndex)) : (!emptyQueryString ? this.internalRef.substring(0, this.queryIndex + 1) + query : this.internalRef.substring(0, this.queryIndex));
        } else if (this.hasFragment()) {
            if (!emptyQueryString) {
                this.internalRef = this.internalRef.substring(0, this.fragmentIndex) + '?' + query + this.internalRef.substring(this.fragmentIndex);
            }
        } else if (!emptyQueryString) {
            this.internalRef = this.internalRef != null ? this.internalRef + '?' + query : '?' + query;
        }
        this.updateIndexes();
    }

    public void setRelativePart(String relativePart) {
        if ((relativePart = this.encodeInvalidCharacters(relativePart)) == null) {
            relativePart = "";
        }
        if (!this.hasScheme()) {
            this.internalRef = this.hasQuery() ? relativePart + this.internalRef.substring(this.queryIndex) : (this.hasFragment() ? relativePart + this.internalRef.substring(this.fragmentIndex) : relativePart);
        }
        this.updateIndexes();
    }

    public void setScheme(String scheme) {
        if ((scheme = this.encodeInvalidCharacters(scheme)) != null) {
            scheme = scheme.toLowerCase();
        }
        if (this.hasScheme()) {
            this.internalRef = scheme != null ? scheme + this.internalRef.substring(this.schemeIndex) : this.internalRef.substring(this.schemeIndex + 1);
        } else if (scheme != null) {
            this.internalRef = this.internalRef == null ? scheme + ':' : scheme + ':' + this.internalRef;
        }
        this.updateIndexes();
    }

    public void setSchemeSpecificPart(String schemeSpecificPart) {
        if ((schemeSpecificPart = this.encodeInvalidCharacters(schemeSpecificPart)) == null) {
            schemeSpecificPart = "";
        }
        this.internalRef = this.hasScheme() ? (this.hasFragment() ? this.internalRef.substring(0, this.schemeIndex + 1) + schemeSpecificPart + this.internalRef.substring(this.fragmentIndex) : this.internalRef.substring(0, this.schemeIndex + 1) + schemeSpecificPart) : (this.hasFragment() ? schemeSpecificPart + this.internalRef.substring(this.fragmentIndex) : schemeSpecificPart);
        this.updateIndexes();
    }

    public void setSegments(List<String> segments) {
        StringBuilder sb = new StringBuilder();
        for (String segment : segments) {
            sb.append('/').append(segment);
        }
        this.setPath(sb.toString());
    }

    public void setUserInfo(String userInfo) {
        String authority = this.getAuthority();
        if (authority != null) {
            String newUserInfo;
            int index = authority.indexOf(64);
            String string = newUserInfo = userInfo == null ? "" : userInfo + '@';
            if (index != -1) {
                this.setAuthority(newUserInfo + authority.substring(index + 1));
            } else {
                this.setAuthority(newUserInfo + authority);
            }
        } else {
            throw new IllegalArgumentException("No authority defined, please define a host name first");
        }
    }

    public String toString() {
        return this.internalRef;
    }

    public String toString(boolean query, boolean fragment) {
        if (query) {
            if (fragment) {
                return this.internalRef;
            }
            if (this.hasFragment()) {
                return this.internalRef.substring(0, this.fragmentIndex);
            }
            return this.internalRef;
        }
        if (fragment) {
            if (this.hasQuery()) {
                if (this.hasFragment()) {
                    return this.internalRef.substring(0, this.queryIndex) + "#" + this.getFragment();
                }
                return this.internalRef.substring(0, this.queryIndex);
            }
            return this.internalRef;
        }
        if (this.hasQuery()) {
            return this.internalRef.substring(0, this.queryIndex);
        }
        if (this.hasFragment()) {
            return this.internalRef.substring(0, this.fragmentIndex);
        }
        return this.internalRef;
    }

    public URI toUri() {
        return URI.create(this.getTargetRef().toString());
    }

    public URL toUrl() {
        URL result = null;
        try {
            result = new URL(this.getTargetRef().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL exception", e);
        }
        return result;
    }

    private void updateIndexes() {
        if (this.internalRef != null) {
            int firstSlashIndex = this.internalRef.indexOf(47);
            this.schemeIndex = this.internalRef.indexOf(58);
            if (firstSlashIndex != -1 && this.schemeIndex > firstSlashIndex) {
                this.schemeIndex = -1;
            }
            this.queryIndex = this.internalRef.indexOf(63);
            this.fragmentIndex = this.internalRef.indexOf(35);
            if (this.hasQuery() && this.hasFragment() && this.queryIndex > this.fragmentIndex) {
                this.queryIndex = -1;
            }
            if (this.hasQuery() && this.schemeIndex > this.queryIndex) {
                this.schemeIndex = -1;
            }
            if (this.hasFragment() && this.schemeIndex > this.fragmentIndex) {
                this.schemeIndex = -1;
            }
        } else {
            this.schemeIndex = -1;
            this.queryIndex = -1;
            this.fragmentIndex = -1;
        }
    }

    static {
        for (int character = 0; character < 127; ++character) {
            Reference.charValidityMap[character] = Reference.isReserved(character) || Reference.isUnreserved(character) || character == 37;
        }
    }
}

