/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.webapp;

import java.util.Properties;

import org.ajax4jsf.Messages;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.xml.DOMConfigurator;

/**
 * @author shura (latest modification by $Author: alexsmirnov $)
 * @version $Revision: 1.1.2.1 $ $Date: 2007/01/09 18:58:18 $
 *
 */
class Log4JConfigurator {
	private static final String CONTEXT_ROOT_VARIABLE = "context-root";
	private Properties props = new Properties();
	private String prefix;
	
	DOMConfigurator domConfig;
	
	void doConfigure(String file){
		domConfig.doConfigure(prefix + file, LogManager.getLoggerRepository());
	}


	/**
	 * @param prefix
	 */
	public Log4JConfigurator(String prefix) {
		this.prefix = prefix;
		props.setProperty(CONTEXT_ROOT_VARIABLE, prefix);
		domConfig = new DOMConfigurator() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.apache.log4j.xml.DOMConfigurator#subst(java.lang.String)
			 *      append context-related properties for variable
			 *      substitution.
			 */
			protected String subst(String value) {
				try {
					return OptionConverter.substVars(value, props);
				} catch (IllegalArgumentException e) {
					LogLog.warn(Messages.getMessage(Messages.VARIABLE_SUBSTITUTION_WARNING), e);
					return value;
				}
			};

		};
		}
}
