/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.SkinFactory;

public abstract class OneColorBasedResource
extends Java2Dresource {
    private Dimension dimension;
    private String basicColorParamName;
    private Color basicColor;

    public OneColorBasedResource(int width, int height, String basicColorParamName) {
        this.basicColorParamName = basicColorParamName;
        this.dimension = new Dimension(width, height);
        this.setRenderer(new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.dimension;
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return this.dimension;
    }

    public boolean isCacheable(ResourceContext ctx) {
        return true;
    }

    public Color getBasicColor() {
        return this.basicColor;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        byte[] retVal = null;
        if (this.basicColor == null) {
            this.basicColor = this.getColorValueParameter(context, this.basicColorParamName);
        }
        if (this.basicColor != null) {
            retVal = new byte[3];
            new Zipper2(retVal).addColor(this.basicColor);
            return retVal;
        }
        return null;
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            this.basicColor = zipper2.nextColor();
        }
        return objectArray;
    }

    private Color getColorValueParameter(FacesContext context, String name) {
        Color retVal = null;
        String color = (String)SkinFactory.getInstance().getSkin(context).getParameter(context, name);
        if (color != null && !color.trim().equals("")) {
            retVal = HtmlColor.decode(color);
        }
        return retVal;
    }
}

