/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.LRUMapCacheFactory;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    private static final Logger log = RichfacesLogger.CACHE.getLogger();
    private static final String FACTORY_PROPERTY_NAME = "org.ajax4jsf.cache.CacheFactory";
    public static final String CACHE_MANAGER_FACTORY_CLASS = "org.ajax4jsf.cache.CACHE_MANAGER_FACTORY_CLASS";
    private static final String[] DEFAULT_FACTORIES_CHAIN = new String[]{"org.ajax4jsf.cache.JBossCacheCacheFactory", "org.ajax4jsf.cache.EhCacheCacheFactory"};
    protected static CacheManager instance = new CacheManager();
    private final Map<String, Cache> caches = Collections.synchronizedMap(new HashMap());

    public static CacheManager getInstance() {
        return instance;
    }

    public Cache getCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    public void registerCache(String cacheName, Cache cache) {
        this.caches.put(cacheName, cache);
    }

    public void createCache(String cacheName, Map<?, ?> env) {
        CacheFactory factory = this.getCacheFactory(env);
        Cache cache = factory.createCache(env);
        this.registerCache(cacheName, cache);
        cache.start();
    }

    public void destroyCache(String cacheName) {
        Cache cache = this.caches.remove(cacheName);
        cache.stop();
    }

    public CacheFactory getCacheFactory(Map<?, ?> env) {
        String[] factories;
        String configuredFactoryName = this.findFactory(FACTORY_PROPERTY_NAME, env);
        if (configuredFactoryName != null) {
            log.info("Configured to use [" + configuredFactoryName + "] cache factory");
            factories = new String[]{configuredFactoryName};
        } else {
            factories = DEFAULT_FACTORIES_CHAIN;
        }
        ClassLoader loader = this.findClassLoader();
        for (String factoryName : factories) {
            try {
                Class<?> spiClass = Class.forName(factoryName, true, loader);
                CacheFactory cacheFactory = (CacheFactory)CacheFactory.class.cast(spiClass.newInstance());
                log.info("Selected [" + factoryName + "]");
                return cacheFactory;
            }
            catch (Throwable iae) {
            }
        }
        log.info("Selected fallback cache factory");
        return new LRUMapCacheFactory();
    }

    public Map<String, Cache> getCaches() {
        return this.caches;
    }

    private ClassLoader findClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private boolean isEmptyString(String s) {
        return s == null || "".equals(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String findFactory(String factoryId, Map<?, ?> env) {
        block16: {
            String envFactoryClass = (String)env.get(CACHE_MANAGER_FACTORY_CLASS);
            if (!this.isEmptyString(envFactoryClass)) {
                return envFactoryClass;
            }
            try {
                String factoryClass = System.getProperty(factoryId);
                if (!this.isEmptyString(factoryClass)) {
                    return factoryClass;
                }
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            try {
                String configFile = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jcache.properties";
                File f = new File(configFile);
                if (!f.exists()) break block16;
                FileInputStream in = new FileInputStream(f);
                try {
                    Properties props = new Properties();
                    props.load(in);
                    String factoryClass = props.getProperty(factoryId);
                    if (!this.isEmptyString(factoryClass)) {
                        String string = factoryClass;
                        return string;
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (SecurityException ignore) {
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        try {
            ClassLoader cl = this.findClassLoader();
            InputStream is = URLToStreamHelper.urlToStreamSafe((URL)cl.getResource("META-INF/services/" + factoryId));
            if (is == null) return null;
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            try {
                String factoryName = r.readLine();
                if (this.isEmptyString(factoryName)) return null;
                String string = factoryName;
                return string;
            }
            finally {
                r.close();
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return null;
    }
}

