/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.config.WebXMLParser;
import org.richfaces.VersionBean;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class WebXml
extends WebXMLParser
implements Serializable {
    public static final String CONTEXT_ATTRIBUTE = WebXml.class.getName();
    private static final long serialVersionUID = -9042908418843695017L;
    static final Logger _log = RichfacesLogger.WEBAPP.getLogger();
    public static final String RESOURCE_URI_PREFIX = "a4j";
    public static final String GLOBAL_RESOURCE_URI_PREFIX = "a4j/g";
    public static final String SESSION_RESOURCE_URI_PREFIX = "a4j/s";
    public static final String RESOURCE_URI_PREFIX_VERSIONED;
    public static final String GLOBAL_RESOURCE_URI_PREFIX_VERSIONED;
    public static final String SESSION_RESOURCE_URI_PREFIX_VERSIONED;
    public static final String RESOURCE_URI_PREFIX_PARAM = "org.ajax4jsf.RESOURCE_URI_PREFIX";
    public static final String GLOBAL_RESOURCE_URI_PREFIX_PARAM = "org.ajax4jsf.GLOBAL_RESOURCE_URI_PREFIX";
    public static final String SESSION_RESOURCE_URI_PREFIX_PARAM = "org.ajax4jsf.SESSION_RESOURCE_URI_PREFIX";
    String _resourcePrefix = "a4j";
    String _globalResourcePrefix;
    String _sessionResourcePrefix;
    protected boolean _prefixMapping = false;

    public static WebXml getInstance() {
        return WebXml.getInstance(FacesContext.getCurrentInstance());
    }

    public static WebXml getInstance(FacesContext context) {
        WebXml webXml = (WebXml)context.getExternalContext().getApplicationMap().get(CONTEXT_ATTRIBUTE);
        return webXml;
    }

    public void init(ServletContext context, String filterName) throws ServletException {
        super.init(context, filterName);
        this.setupResourcePrefixes(context);
        context.setAttribute(CONTEXT_ATTRIBUTE, (Object)this);
    }

    public String getFacesResourceURL(FacesContext context, String Url, boolean isGlobal) {
        StringBuffer buf = new StringBuffer();
        buf.append(isGlobal ? this.getGlobalResourcePrefix() : this.getSessionResourcePrefix()).append(Url);
        if (this.isPrefixMapping()) {
            buf.insert(0, this.getFacesFilterPrefix());
        } else {
            int index = buf.indexOf("?");
            if (index >= 0) {
                buf.insert(index, this.getFacesFilterSuffix());
            } else {
                buf.append(this.getFacesFilterSuffix());
            }
        }
        String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, buf.toString());
        return resourceURL;
    }

    @Deprecated
    public String getFacesResourceURL(FacesContext context, String Url) {
        return this.getFacesResourceURL(context, Url, false);
    }

    public String getFacesResourceKey(String resourcePath) {
        int jsesionidStart = resourcePath.lastIndexOf(";jsessionid");
        if (jsesionidStart >= 0) {
            resourcePath = resourcePath.substring(0, jsesionidStart);
        }
        String resourcePrefix = this.getResourcePrefix();
        if (this.isPrefixMapping()) {
            String facesFilterPrefix = this.getFacesFilterPrefix();
            if (resourcePath.startsWith(facesFilterPrefix)) {
                String sessionResourcePrefix = this.getSessionResourcePrefix();
                if (resourcePath.startsWith(sessionResourcePrefix, facesFilterPrefix.length())) {
                    return resourcePath.substring(facesFilterPrefix.length() + sessionResourcePrefix.length());
                }
                String globalResourcePrefix = this.getGlobalResourcePrefix();
                if (!sessionResourcePrefix.equals(globalResourcePrefix) && resourcePath.startsWith(globalResourcePrefix, facesFilterPrefix.length())) {
                    return resourcePath.substring(facesFilterPrefix.length() + globalResourcePrefix.length());
                }
                if (!globalResourcePrefix.equals(resourcePrefix) && resourcePath.startsWith(resourcePrefix, facesFilterPrefix.length())) {
                    return resourcePath.substring(facesFilterPrefix.length() + resourcePrefix.length());
                }
            }
        } else {
            String sessionResourcePrefix = this.getSessionResourcePrefix();
            if (resourcePath.startsWith(sessionResourcePrefix)) {
                return resourcePath.substring(sessionResourcePrefix.length(), resourcePath.length() - this.getFacesFilterSuffix().length());
            }
            String globalResourcePrefix = this.getGlobalResourcePrefix();
            if (!sessionResourcePrefix.equals(globalResourcePrefix) && resourcePath.startsWith(globalResourcePrefix)) {
                return resourcePath.substring(globalResourcePrefix.length(), resourcePath.length() - this.getFacesFilterSuffix().length());
            }
            if (!globalResourcePrefix.equals(resourcePrefix) && resourcePath.startsWith(resourcePrefix)) {
                return resourcePath.substring(resourcePrefix.length(), resourcePath.length() - this.getFacesFilterSuffix().length());
            }
        }
        return null;
    }

    public String getFacesResourceKey(HttpServletRequest request) {
        String resourcePath = request.getRequestURI().substring(request.getContextPath().length());
        return this.getFacesResourceKey(resourcePath);
    }

    public boolean isFacesRequest(HttpServletRequest request) {
        return true;
    }

    @Deprecated
    public String getResourcePrefix() {
        return this._resourcePrefix;
    }

    public String getGlobalResourcePrefix() {
        return this._globalResourcePrefix;
    }

    public String getSessionResourcePrefix() {
        return this._sessionResourcePrefix;
    }

    public boolean isPrefixMapping() {
        return this._prefixMapping;
    }

    @Deprecated
    void setResourcePrefix(String resourcePrefix) {
        this._resourcePrefix = resourcePrefix;
    }

    void setGlobalResourcePrefix(String resourcePrefix) {
        this._globalResourcePrefix = resourcePrefix;
    }

    void setSessionResourcePrefix(String resourcePrefix) {
        this._sessionResourcePrefix = resourcePrefix;
    }

    void setupResourcePrefixes(ServletContext context) {
        String globalResourcePrefix = context.getInitParameter(GLOBAL_RESOURCE_URI_PREFIX_PARAM);
        String sessionResourcePrefix = context.getInitParameter(SESSION_RESOURCE_URI_PREFIX_PARAM);
        String resourcePrefix = context.getInitParameter(RESOURCE_URI_PREFIX_PARAM);
        if (null != resourcePrefix) {
            if (globalResourcePrefix == null) {
                globalResourcePrefix = resourcePrefix;
            }
            if (sessionResourcePrefix == null) {
                sessionResourcePrefix = resourcePrefix;
            }
        } else {
            resourcePrefix = RESOURCE_URI_PREFIX_VERSIONED;
        }
        if (globalResourcePrefix == null) {
            globalResourcePrefix = GLOBAL_RESOURCE_URI_PREFIX_VERSIONED;
        }
        if (sessionResourcePrefix == null) {
            sessionResourcePrefix = SESSION_RESOURCE_URI_PREFIX_VERSIONED;
        }
        if (null != this.getFacesFilterPrefix()) {
            this._prefixMapping = true;
            if (this.getFacesFilterPrefix().endsWith("/")) {
                this.setGlobalResourcePrefix(globalResourcePrefix);
                this.setSessionResourcePrefix(sessionResourcePrefix);
                this.setResourcePrefix(resourcePrefix);
            } else {
                this.setGlobalResourcePrefix("/" + globalResourcePrefix);
                this.setSessionResourcePrefix("/" + sessionResourcePrefix);
                this.setResourcePrefix("/" + resourcePrefix);
            }
        } else if (null != this.getFacesFilterSuffix()) {
            this._prefixMapping = false;
            this.setResourcePrefix("/" + resourcePrefix);
            this.setGlobalResourcePrefix("/" + globalResourcePrefix);
            this.setSessionResourcePrefix("/" + sessionResourcePrefix);
        }
    }

    static {
        VersionBean versionBean = new VersionBean();
        VersionBean.Version version = versionBean.getVersion();
        String suffix = "/" + version.getMajor() + "_" + version.getMinor() + "_" + version.getRevision();
        RESOURCE_URI_PREFIX_VERSIONED = RESOURCE_URI_PREFIX + suffix;
        GLOBAL_RESOURCE_URI_PREFIX_VERSIONED = GLOBAL_RESOURCE_URI_PREFIX + suffix;
        SESSION_RESOURCE_URI_PREFIX_VERSIONED = SESSION_RESOURCE_URI_PREFIX + suffix;
    }
}

