/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Date;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.util.Util;
import org.slf4j.Logger;

public abstract class AbstractCacheableResource
extends Resource {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();

    protected abstract Date getLastModified(FacesContext var1);

    public abstract boolean isCacheable(FacesContext var1);

    protected abstract String getEntityTag(FacesContext var1);

    private Boolean userCopyIsActual(Date lastModified, Date modifiedCondition) {
        if (modifiedCondition == null) {
            return null;
        }
        if (lastModified == null) {
            return Boolean.FALSE;
        }
        return lastModified.getTime() - modifiedCondition.getTime() <= 1000L;
    }

    protected Boolean matchesLastModified(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestHeaderMap = externalContext.getRequestHeaderMap();
        String modifiedCondition = (String)requestHeaderMap.get("If-Modified-Since");
        return this.userCopyIsActual(this.getLastModified(context), Util.parseHttpDate(modifiedCondition));
    }

    protected Boolean matchesEntityTag(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestHeaderMap = externalContext.getRequestHeaderMap();
        String matchHeaderValue = (String)requestHeaderMap.get("If-None-Match");
        if (matchHeaderValue == null) {
            return null;
        }
        String resourceEntityTag = this.getEntityTag(context);
        if (resourceEntityTag != null) {
            return ResourceUtils.matchTag(resourceEntityTag, matchHeaderValue);
        }
        return Boolean.FALSE;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (!this.isCacheable(context)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource is not cacheable");
            }
            return true;
        }
        Boolean matchesEntityTag = this.matchesEntityTag(context);
        if (Boolean.FALSE.equals(matchesEntityTag)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: entity tags don't match");
            }
            return true;
        }
        Boolean matchesLastModified = this.matchesLastModified(context);
        if (Boolean.FALSE.equals(matchesLastModified)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource was modified since the last request");
            }
            return true;
        }
        if (matchesLastModified == null && matchesEntityTag == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: no cache information was provided in request");
            }
            return true;
        }
        return false;
    }
}

