/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.VersionBean;
import org.richfaces.resource.AbstractBaseResource;

public class TestResource
extends AbstractBaseResource
implements StateHolder {
    private String filePath;

    public String getContentType() {
        return "image/png";
    }

    protected int getContentLength(FacesContext context) {
        return (int)new File(this.filePath).length();
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getVersion() {
        VersionBean.Version version = new VersionBean().getVersion();
        return version.getMajor() + "." + version.getMinor() + "." + version.getRevision();
    }

    protected void writeState(ByteArrayOutputStream baos) {
        try {
            baos.write("c:\\tmp\\test.png".getBytes("US-ASCII"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void readState(ByteArrayInputStream bais) {
        int available = bais.available();
        byte[] bs = new byte[available];
        try {
            bais.read(bs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.filePath = new String(bs, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public Object saveState(FacesContext context) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeState(baos);
        return baos.toByteArray();
    }

    public void restoreState(FacesContext context, Object state) {
        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);
        this.readState(bais);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

