/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.util.base64.Codec;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class Util {
    private static final Logger resourceLogger = RichfacesLogger.RESOURCE.getLogger();
    private static final String RFC1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat RFC1123_DATE_FORMATTER;
    private static final Codec CODEC;
    private static final String DATA_SEPARATOR = "/DATA/";
    private static final String DATA_BYTES_SEPARATOR = "/DATB/";
    private static final String VERSION_SEPARATOR = "/VER";
    private static final Pattern DATA_SEPARATOR_PATTERN;
    private static final int DATA_SEPARATOR_TYPE_GROUP_INDEX = 1;
    private static final int DATA_SEPARATOR_DATA_GROUP_INDEX = 2;

    private Util() {
    }

    public static String getMappingForRequest(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String servletPath = externalContext.getRequestServletPath();
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/";
        }
        String pathInfo = externalContext.getRequestPathInfo();
        if (pathInfo != null) {
            return servletPath;
        }
        int idx = servletPath.lastIndexOf(46);
        if (idx < 0) {
            return servletPath;
        }
        return servletPath.substring(idx);
    }

    public static Date parseHttpDate(String s) {
        Date result = null;
        if (s != null) {
            try {
                result = (Date)((Format)RFC1123_DATE_FORMATTER.clone()).parseObject(s);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String formatHttpDate(Object object) {
        if (object != null) {
            return ((Format)RFC1123_DATE_FORMATTER.clone()).format(object);
        }
        return null;
    }

    protected static byte[] encrypt(byte[] src) {
        try {
            Deflater compressor = new Deflater(1);
            byte[] compressed = new byte[src.length + 100];
            compressor.setInput(src);
            compressor.finish();
            int totalOut = compressor.deflate(compressed);
            byte[] zipsrc = new byte[totalOut];
            System.arraycopy(compressed, 0, zipsrc, 0, totalOut);
            compressor.end();
            return CODEC.encode(zipsrc);
        }
        catch (Exception e) {
            throw new FacesException("Error encode resource data", (Throwable)e);
        }
    }

    protected static byte[] decrypt(byte[] src) {
        try {
            byte[] zipsrc = CODEC.decode(src);
            Inflater decompressor = new Inflater();
            byte[] uncompressed = new byte[zipsrc.length * 5];
            decompressor.setInput(zipsrc);
            int totalOut = decompressor.inflate(uncompressed);
            byte[] out = new byte[totalOut];
            System.arraycopy(uncompressed, 0, out, 0, totalOut);
            decompressor.end();
            return out;
        }
        catch (Exception e) {
            throw new FacesException("Error decode resource data", (Throwable)e);
        }
    }

    public static String encodeResourceData(String resourceName, Object storeData, String resourceVersion) {
        StringBuffer uri = new StringBuffer();
        uri.append(resourceName);
        if (storeData != null) {
            try {
                byte[] objectData;
                if (storeData instanceof byte[]) {
                    objectData = (byte[])storeData;
                    uri.append(DATA_BYTES_SEPARATOR);
                } else {
                    ByteArrayOutputStream dataSteram = new ByteArrayOutputStream(1024);
                    ObjectOutputStream objStream = new ObjectOutputStream(dataSteram);
                    objStream.writeObject(storeData);
                    objStream.flush();
                    objStream.close();
                    dataSteram.close();
                    objectData = dataSteram.toByteArray();
                    uri.append(DATA_SEPARATOR);
                }
                byte[] dataArray = Util.encrypt(objectData);
                uri.append(new String(dataArray, "ISO-8859-1"));
            }
            catch (Exception e) {
                resourceLogger.error(Messages.getMessage((String)"QUERY_STRING_BUILDING_ERROR"), (Throwable)e);
            }
        }
        if (resourceVersion != null && resourceVersion.length() != 0) {
            uri.append(VERSION_SEPARATOR);
            uri.append(resourceVersion);
        }
        return uri.toString();
    }

    public static String getResourceName(String resourceUri) {
        String resourceName = resourceUri;
        Matcher matcher = DATA_SEPARATOR_PATTERN.matcher(resourceName);
        if (matcher.find()) {
            int data = matcher.start();
            resourceName = resourceName.substring(0, data);
        } else {
            int idx = resourceName.indexOf(VERSION_SEPARATOR);
            if (idx > 0) {
                resourceName = resourceName.substring(0, idx);
            }
        }
        return resourceName;
    }

    public static String getResourceVersion(String resourceUri) {
        int idx = resourceUri.indexOf(VERSION_SEPARATOR);
        if (idx > 0) {
            return resourceUri.substring(idx + VERSION_SEPARATOR.length());
        }
        return null;
    }

    public static Object getResourceData(String resourceUri) {
        Object data = null;
        String dataString = null;
        Matcher matcher = DATA_SEPARATOR_PATTERN.matcher(resourceUri);
        if (matcher.find()) {
            if (resourceLogger.isDebugEnabled()) {
                resourceLogger.debug(Messages.getMessage((String)"RESTORE_DATA_FROM_RESOURCE_URI_INFO", (Object)resourceUri, (Object)dataString));
            }
            dataString = matcher.group(2);
            byte[] objectArray = null;
            try {
                byte[] dataArray = dataString.getBytes("ISO-8859-1");
                objectArray = Util.decrypt(dataArray);
            }
            catch (UnsupportedEncodingException e1) {
                // empty catch block
            }
            if ("B".equals(matcher.group(1))) {
                data = objectArray;
            } else {
                try {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(objectArray));
                    data = in.readObject();
                }
                catch (StreamCorruptedException e) {
                    resourceLogger.error(Messages.getMessage((String)"STREAM_CORRUPTED_ERROR"), (Throwable)e);
                }
                catch (IOException e) {
                    resourceLogger.error(Messages.getMessage((String)"DESERIALIZE_DATA_INPUT_ERROR"), (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    resourceLogger.error(Messages.getMessage((String)"DATA_CLASS_NOT_FOUND_ERROR"), (Throwable)e);
                }
            }
        }
        return data;
    }

    public static String encodeResourceURL(FacesContext context, String url) {
        String mapping = Util.getMappingForRequest(context);
        String resourcePath = url;
        if (mapping.startsWith("/")) {
            if (mapping.length() != 1) {
                resourcePath = mapping + url;
            }
        } else {
            resourcePath = resourcePath + mapping;
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        return viewHandler.getResourceURL(context, resourcePath);
    }

    public static String decodeResourceURL(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String resourceName = null;
        String facesMapping = Util.getMappingForRequest(context);
        if (facesMapping != null) {
            if (facesMapping.startsWith("/")) {
                resourceName = externalContext.getRequestPathInfo();
            } else {
                String requestServletPath = externalContext.getRequestServletPath();
                resourceName = requestServletPath.substring(0, requestServletPath.length() - facesMapping.length());
            }
        }
        return resourceName;
    }

    public static void copyStreamContent(InputStream is, OutputStream os) throws IOException {
        int read;
        ReadableByteChannel inChannel = Channels.newChannel(is);
        WritableByteChannel outChannel = Channels.newChannel(os);
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while ((read = inChannel.read(buffer)) > 0) {
            buffer.rewind();
            buffer.limit(read);
            while (read > 0) {
                read -= outChannel.write(buffer);
            }
            buffer.clear();
        }
    }

    static {
        SimpleDateFormat format = new SimpleDateFormat(RFC1123_DATE_PATTERN, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        RFC1123_DATE_FORMATTER = format;
        CODEC = new Codec();
        DATA_SEPARATOR_PATTERN = Pattern.compile("/DAT(A|B)/([^/]*)");
    }
}

