/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.app.ambientcontext.AmbientContextEventRequest;
import android.app.ambientcontext.AmbientContextManager;
import com.android.internal.annotations.GuardedBy;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=AmbientContextManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowAmbientContextManager {
    private final Object lock = new Object();
    @GuardedBy(value={"lock"})
    private AmbientContextEventRequest lastRegisterObserverRequest;
    @GuardedBy(value={"lock"})
    private Integer ambientContextServiceStatus = 2;
    @GuardedBy(value={"lock"})
    private Set<Integer> lastRequestedEventCodesForConsentActivity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void registerObserver(AmbientContextEventRequest request, PendingIntent resultPendingIntent, Executor executor, Consumer<Integer> statusConsumer) {
        Object object = this.lock;
        synchronized (object) {
            this.lastRegisterObserverRequest = request;
            statusConsumer.accept(this.ambientContextServiceStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void unregisterObserver() {
        Object object = this.lock;
        synchronized (object) {
            this.lastRegisterObserverRequest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmbientContextEventRequest getLastRegisterObserverRequest() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastRegisterObserverRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void queryAmbientContextServiceStatus(Set<Integer> eventTypes, Executor executor, Consumer<Integer> consumer) {
        Object object = this.lock;
        synchronized (object) {
            consumer.accept(this.ambientContextServiceStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAmbientContextServiceStatus(Integer status) {
        Object object = this.lock;
        synchronized (object) {
            this.ambientContextServiceStatus = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void startConsentActivity(Set<Integer> eventTypes) {
        Object object = this.lock;
        synchronized (object) {
            this.lastRequestedEventCodesForConsentActivity = eventTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> getLastRequestedEventCodesForConsentActivity() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastRequestedEventCodesForConsentActivity;
        }
    }
}

