/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.IAccountManager;
import android.app.IAlarmManager;
import android.app.ILocaleManager;
import android.app.INotificationManager;
import android.app.ISearchManager;
import android.app.IUiModeManager;
import android.app.IWallpaperManager;
import android.app.admin.IDevicePolicyManager;
import android.app.ambientcontext.IAmbientContextManager;
import android.app.job.IJobScheduler;
import android.app.role.IRoleManager;
import android.app.slice.ISliceManager;
import android.app.timedetector.ITimeDetectorService;
import android.app.timezonedetector.ITimeZoneDetectorService;
import android.app.trust.ITrustManager;
import android.app.usage.IStorageStatsManager;
import android.app.usage.IUsageStatsManager;
import android.app.wearable.IWearableSensingManager;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothManager;
import android.companion.ICompanionDeviceManager;
import android.companion.virtual.IVirtualDeviceManager;
import android.content.IClipboard;
import android.content.IRestrictionsManager;
import android.content.integrity.IAppIntegrityManager;
import android.content.pm.ICrossProfileApps;
import android.content.pm.IShortcutService;
import android.content.rollback.IRollbackManager;
import android.hardware.ISensorPrivacyManager;
import android.hardware.biometrics.IAuthService;
import android.hardware.biometrics.IBiometricService;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.input.IInputManager;
import android.hardware.location.IContextHubService;
import android.hardware.usb.IUsbManager;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.media.IAudioService;
import android.media.IMediaRouterService;
import android.media.session.ISessionManager;
import android.net.IConnectivityManager;
import android.net.IIpSecService;
import android.net.INetworkPolicyManager;
import android.net.INetworkScoreService;
import android.net.ITetheringConnector;
import android.net.IVpnManager;
import android.net.nsd.INsdManager;
import android.net.vcn.IVcnManagementService;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.rtt.IWifiRttManager;
import android.nfc.INfcAdapter;
import android.os.Binder;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IDumpstate;
import android.os.IInterface;
import android.os.IPowerManager;
import android.os.IThermalService;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import android.permission.ILegacyPermissionManager;
import android.permission.IPermissionManager;
import android.safetycenter.ISafetyCenterManager;
import android.security.IFileIntegrityService;
import android.speech.IRecognitionServiceManager;
import android.uwb.IUwbAdapter;
import android.view.IWindowManager;
import android.view.contentcapture.IContentCaptureManager;
import android.view.translation.ITranslationManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.app.ISoundTriggerService;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.compat.IPlatformCompat;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.statusbar.IStatusBar;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.view.IInputMethodManager;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.IBluetoothManagerDelegates;
import org.robolectric.shadows.WifiScannerDelegate;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ServiceManager.class, isInAndroidSdk=false)
public class ShadowServiceManager {
    protected static final Map<String, BinderService> binderServices = ShadowServiceManager.buildBinderServicesMap();
    @GuardedBy(value="ShadowServiceManager.class")
    private static final Set<String> unavailableServices = new HashSet<String>();

    private static Map<String, BinderService> buildBinderServicesMap() {
        HashMap<String, BinderService> binderServices = new HashMap<String, BinderService>();
        ShadowServiceManager.addBinderService(binderServices, "clipboard", IClipboard.class);
        ShadowServiceManager.addBinderService(binderServices, "wifip2p", IWifiP2pManager.class);
        ShadowServiceManager.addBinderService(binderServices, "account", IAccountManager.class);
        ShadowServiceManager.addBinderService(binderServices, "usb", IUsbManager.class);
        ShadowServiceManager.addBinderService(binderServices, "location", ILocationManager.class);
        ShadowServiceManager.addBinderService(binderServices, "input_method", IInputMethodManager.class);
        ShadowServiceManager.addBinderService(binderServices, "alarm", IAlarmManager.class);
        ShadowServiceManager.addBinderService(binderServices, "power", IPowerManager.class);
        ShadowServiceManager.addBinderService(binderServices, "batterystats", IBatteryStats.class);
        ShadowServiceManager.addBinderService(binderServices, "dropbox", IDropBoxManagerService.class);
        ShadowServiceManager.addBinderService(binderServices, "device_policy", IDevicePolicyManager.class);
        ShadowServiceManager.addBinderService(binderServices, "phone", ITelephony.class);
        ShadowServiceManager.addBinderService(binderServices, "connectivity", IConnectivityManager.class);
        ShadowServiceManager.addBinderService(binderServices, "wifi", IWifiManager.class);
        ShadowServiceManager.addBinderService(binderServices, "search", ISearchManager.class);
        ShadowServiceManager.addBinderService(binderServices, "uimode", IUiModeManager.class);
        ShadowServiceManager.addBinderService(binderServices, "netpolicy", INetworkPolicyManager.class);
        ShadowServiceManager.addBinderService(binderServices, "input", IInputManager.class);
        ShadowServiceManager.addBinderService(binderServices, "country_detector", ICountryDetector.class);
        ShadowServiceManager.addBinderService(binderServices, "servicediscovery", INsdManager.class);
        ShadowServiceManager.addBinderService(binderServices, "audio", IAudioService.class);
        ShadowServiceManager.addBinderService(binderServices, "appwidget", IAppWidgetService.class);
        ShadowServiceManager.addBinderService(binderServices, "notification", INotificationManager.class);
        ShadowServiceManager.addBinderService(binderServices, "wallpaper", IWallpaperManager.class);
        ShadowServiceManager.addBinderService(binderServices, "bluetooth", IBluetooth.class);
        ShadowServiceManager.addBinderService(binderServices, "window", IWindowManager.class);
        ShadowServiceManager.addBinderService(binderServices, "nfc", INfcAdapter.class, BinderProxyType.DEEP);
        ShadowServiceManager.addBinderService(binderServices, "user", IUserManager.class);
        ShadowServiceManager.addBinderService(binderServices, "bluetooth_manager", IBluetoothManager.class, BinderProxyType.DELEGATING, IBluetoothManagerDelegates.createDelegate());
        ShadowServiceManager.addBinderService(binderServices, "appops", IAppOpsService.class);
        ShadowServiceManager.addBinderService(binderServices, "batteryproperties", IBatteryPropertiesRegistrar.class);
        ShadowServiceManager.addBinderService(binderServices, "restrictions", IRestrictionsManager.class);
        ShadowServiceManager.addBinderService(binderServices, "trust", ITrustManager.class);
        ShadowServiceManager.addBinderService(binderServices, "jobscheduler", IJobScheduler.class);
        ShadowServiceManager.addBinderService(binderServices, "network_score", INetworkScoreService.class);
        ShadowServiceManager.addBinderService(binderServices, "usagestats", IUsageStatsManager.class);
        ShadowServiceManager.addBinderService(binderServices, "media_router", IMediaRouterService.class);
        ShadowServiceManager.addBinderService(binderServices, "media_session", ISessionManager.class, BinderProxyType.DEEP);
        ShadowServiceManager.addBinderService(binderServices, "voiceinteraction", IVoiceInteractionManagerService.class, BinderProxyType.DEEP);
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            ShadowServiceManager.addBinderService(binderServices, "fingerprint", IFingerprintService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            ShadowServiceManager.addBinderService(binderServices, "contexthub", IContextHubService.class);
            ShadowServiceManager.addBinderService(binderServices, "soundtrigger", ISoundTriggerService.class);
            ShadowServiceManager.addBinderService(binderServices, "wifiscanner", IWifiScanner.class, BinderProxyType.DELEGATING, new WifiScannerDelegate());
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            ShadowServiceManager.addBinderService(binderServices, "shortcut", IShortcutService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            ShadowServiceManager.addBinderService(binderServices, "mount", IStorageManager.class);
            ShadowServiceManager.addBinderService(binderServices, "wifiaware", IWifiAwareManager.class);
            ShadowServiceManager.addBinderService(binderServices, "storagestats", IStorageStatsManager.class);
            ShadowServiceManager.addBinderService(binderServices, "companiondevice", ICompanionDeviceManager.class);
        } else {
            ShadowServiceManager.addBinderService(binderServices, "mount", "android.os.storage.IMountService");
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            ShadowServiceManager.addBinderService(binderServices, "slice", ISliceManager.class);
            ShadowServiceManager.addBinderService(binderServices, "crossprofileapps", ICrossProfileApps.class);
            ShadowServiceManager.addBinderService(binderServices, "wifirtt", IWifiRttManager.class);
            ShadowServiceManager.addBinderService(binderServices, "ipsec", IIpSecService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            ShadowServiceManager.addBinderService(binderServices, "biometric", IBiometricService.class);
            ShadowServiceManager.addBinderService(binderServices, "content_capture", IContentCaptureManager.class);
            ShadowServiceManager.addBinderService(binderServices, "role", IRoleManager.class);
            ShadowServiceManager.addBinderService(binderServices, "rollback", IRollbackManager.class);
            ShadowServiceManager.addBinderService(binderServices, "thermalservice", IThermalService.class);
            ShadowServiceManager.addBinderService(binderServices, "bugreport", IDumpstate.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            ShadowServiceManager.addBinderService(binderServices, "app_integrity", IAppIntegrityManager.class);
            ShadowServiceManager.addBinderService(binderServices, "auth", IAuthService.class);
            ShadowServiceManager.addBinderService(binderServices, "tethering", ITetheringConnector.class);
            ShadowServiceManager.addBinderService(binderServices, "telephony.registry", ITelephonyRegistry.class);
            ShadowServiceManager.addBinderService(binderServices, "platform_compat", IPlatformCompat.class);
            ShadowServiceManager.addBinderService(binderServices, "file_integrity", IFileIntegrityService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 31) {
            ShadowServiceManager.addBinderService(binderServices, "permissionmgr", IPermissionManager.class);
            ShadowServiceManager.addBinderService(binderServices, "time_zone_detector", ITimeZoneDetectorService.class);
            ShadowServiceManager.addBinderService(binderServices, "time_detector", ITimeDetectorService.class);
            ShadowServiceManager.addBinderService(binderServices, "speech_recognition", IRecognitionServiceManager.class);
            ShadowServiceManager.addBinderService(binderServices, "legacy_permission", ILegacyPermissionManager.class);
            ShadowServiceManager.addBinderService(binderServices, "uwb", IUwbAdapter.class);
            ShadowServiceManager.addBinderService(binderServices, "vcn_management", IVcnManagementService.class);
            ShadowServiceManager.addBinderService(binderServices, "translation", ITranslationManager.class);
            ShadowServiceManager.addBinderService(binderServices, "sensor_privacy", ISensorPrivacyManager.class);
            ShadowServiceManager.addBinderService(binderServices, "vpn_management", IVpnManager.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            ShadowServiceManager.addBinderService(binderServices, "ambient_context", IAmbientContextManager.class);
            ShadowServiceManager.addBinderService(binderServices, "locale", ILocaleManager.class);
            ShadowServiceManager.addBinderService(binderServices, "safety_center", ISafetyCenterManager.class);
            ShadowServiceManager.addBinderService(binderServices, "statusbar", IStatusBar.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            ShadowServiceManager.addBinderService(binderServices, "virtualdevice", IVirtualDeviceManager.class);
            ShadowServiceManager.addBinderService(binderServices, "wearable_sensing", IWearableSensingManager.class);
        }
        return binderServices;
    }

    protected static void addBinderService(Map<String, BinderService> binderServices, String name, Class<? extends IInterface> clazz) {
        ShadowServiceManager.addBinderService(binderServices, name, clazz, clazz.getCanonicalName(), BinderProxyType.NULL, null);
    }

    private static void addBinderService(Map<String, BinderService> binderServices, String name, Class<? extends IInterface> clazz, BinderProxyType proxyType) {
        ShadowServiceManager.addBinderService(binderServices, name, clazz, clazz.getCanonicalName(), proxyType, null);
    }

    private static void addBinderService(Map<String, BinderService> binderServices, String name, String className) {
        Class<IInterface> clazz;
        try {
            clazz = Class.forName(className).asSubclass(IInterface.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ShadowServiceManager.addBinderService(binderServices, name, clazz, className, BinderProxyType.NULL, null);
    }

    private static void addBinderService(Map<String, BinderService> binderServices, String name, Class<? extends IInterface> clazz, BinderProxyType proxyType, @Nullable Object delegate) {
        ShadowServiceManager.addBinderService(binderServices, name, clazz, clazz.getCanonicalName(), proxyType, delegate);
    }

    private static void addBinderService(Map<String, BinderService> binderServices, String name, Class<? extends IInterface> clazz, String className, BinderProxyType proxyType, @Nullable Object delegate) {
        binderServices.put(name, new BinderService(clazz, className, proxyType, delegate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static IBinder getService(String name) {
        Class<ShadowServiceManager> clazz = ShadowServiceManager.class;
        synchronized (ShadowServiceManager.class) {
            if (unavailableServices.contains(name)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ShadowServiceManager.getBinderForService(name);
        }
    }

    @Implementation
    protected static void addService(String name, IBinder service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static IBinder checkService(String name) {
        Class<ShadowServiceManager> clazz = ShadowServiceManager.class;
        synchronized (ShadowServiceManager.class) {
            if (unavailableServices.contains(name)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ShadowServiceManager.getBinderForService(name);
        }
    }

    @Implementation
    protected static String[] listServices() throws RemoteException {
        return null;
    }

    @Implementation
    protected static void initServiceCache(Map<String, IBinder> cache) {
    }

    public static synchronized void setServiceAvailability(String service, boolean available) {
        if (available) {
            unavailableServices.remove(service);
        } else {
            unavailableServices.add(service);
        }
    }

    @Nullable
    @GuardedBy(value="ShadowServiceManager.class")
    private static IBinder getBinderForService(String name) {
        BinderService binderService = binderServices.get(name);
        if (binderService == null) {
            return null;
        }
        return binderService.getBinder();
    }

    @Resetter
    public static synchronized void reset() {
        unavailableServices.clear();
    }

    private static enum BinderProxyType {
        NULL,
        DEEP,
        DELEGATING;

    }

    private static final class BinderService {
        private final Class<? extends IInterface> clazz;
        private final String className;
        private final BinderProxyType proxyType;
        private Binder cachedBinder;
        private final Object delegate;

        BinderService(Class<? extends IInterface> clazz, String className, BinderProxyType proxyType, @Nullable Object delegate) {
            this.clazz = clazz;
            this.className = className;
            this.proxyType = proxyType;
            this.delegate = delegate;
            if (proxyType == BinderProxyType.DELEGATING) {
                Preconditions.checkNotNull((Object)delegate);
            }
        }

        @GuardedBy(value="ShadowServiceManager.class")
        IBinder getBinder() {
            if (this.cachedBinder == null) {
                this.cachedBinder = new Binder();
                this.cachedBinder.attachInterface(this.createProxy(), this.className);
            }
            return this.cachedBinder;
        }

        private IInterface createProxy() {
            switch (this.proxyType.ordinal()) {
                case 0: {
                    return (IInterface)ReflectionHelpers.createNullProxy(this.clazz);
                }
                case 1: {
                    return (IInterface)ReflectionHelpers.createDeepProxy(this.clazz);
                }
                case 2: {
                    return (IInterface)ReflectionHelpers.createDelegatingProxy(this.clazz, (Object)this.delegate);
                }
            }
            throw new IllegalStateException("unrecognized proxy type " + (Object)((Object)this.proxyType));
        }
    }
}

