/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.os.Handler;
import android.webkit.WebMessage;
import android.webkit.WebMessagePort;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.annotation.Config;

@Config(minSdk=23)
public class RoboWebMessagePort
extends WebMessagePort {
    private final List<String> receivedMessages = Collections.synchronizedList(new ArrayList());
    private RoboWebMessagePort connectedPort;
    private WebMessagePort.WebMessageCallback callback;
    private boolean closed = false;

    public static RoboWebMessagePort[] createPair() {
        RoboWebMessagePort portA = new RoboWebMessagePort();
        RoboWebMessagePort portB = new RoboWebMessagePort();
        portA.setConnectedPort(portB);
        portB.setConnectedPort(portA);
        return new RoboWebMessagePort[]{portA, portB};
    }

    public void postMessage(WebMessage message) {
        if (this.closed || this.connectedPort == null) {
            return;
        }
        String data = message.getData();
        if (data == null) {
            return;
        }
        this.connectedPort.receivedMessages.add(data);
        if (this.connectedPort.callback != null) {
            this.connectedPort.callback.onMessage((WebMessagePort)this.connectedPort, message);
        }
    }

    public void setWebMessageCallback(WebMessagePort.WebMessageCallback callback) {
        this.setWebMessageCallback(callback, null);
    }

    public void setWebMessageCallback(WebMessagePort.WebMessageCallback callback, @Nullable Handler handler) {
        this.callback = callback;
    }

    public void setConnectedPort(@Nullable RoboWebMessagePort port) {
        this.connectedPort = port;
    }

    public RoboWebMessagePort getConnectedPort() {
        return this.connectedPort;
    }

    public WebMessagePort.WebMessageCallback getWebMessageCallback() {
        return this.callback;
    }

    public ImmutableList<String> getOutgoingMessages() {
        return ImmutableList.copyOf(this.getConnectedPort().receivedMessages);
    }

    public ImmutableList<String> getReceivedMessages() {
        return ImmutableList.copyOf(this.receivedMessages);
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

