/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.services;

import com.dtolabs.client.services.CentralDispatcherFailureResponseException;
import com.dtolabs.client.services.CentralDispatcherServerRequestException;
import com.dtolabs.client.services.JobDefinitionSerializer;
import com.dtolabs.client.services.QueuedItemResultImpl;
import com.dtolabs.client.services.ServerService;
import com.dtolabs.client.services.StoredJobImpl;
import com.dtolabs.client.services.StoredJobLoadResultImpl;
import com.dtolabs.client.utils.WebserviceResponse;
import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcher;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.DeleteJobResult;
import com.dtolabs.rundeck.core.dispatcher.DispatcherResult;
import com.dtolabs.rundeck.core.dispatcher.ExecutionDetail;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowReceiver;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowRequest;
import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowResult;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedJob;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedScript;
import com.dtolabs.rundeck.core.dispatcher.ILoadJobsRequest;
import com.dtolabs.rundeck.core.dispatcher.IStoredJob;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobLoadResult;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobsQuery;
import com.dtolabs.rundeck.core.dispatcher.JobDefinitionFileFormat;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.dispatcher.QueuedItemResult;
import com.dtolabs.rundeck.core.utils.NodeSet;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RundeckCentralDispatcher
implements CentralDispatcher {
    public static final String RUNDECK_EXEC_JOB_PATH = "/scheduledExecution/uploadAndExecute.xml";
    public static final String RUNDECK_LIST_EXECUTIONS_PATH = "/menu/queueList.xml";
    public static final String RUNDECK_KILL_JOB_PATH = "/execution/cancelExecution.xml";
    public static final String RUNDECK_LIST_STORED_JOBS_PATH = "/menu/workflows";
    public static final String RUNDECK_JOB_LINK_PREFIX = "/scheduledExecution/show/";
    public static final String RUNDECK_JOBS_UPLOAD = "/scheduledExecution/upload";
    public static final String RUNDECK_JOBS_RUN = "/scheduledExecution/runJobByName.xml";
    public static final String RUNDECK_API_VERSION = "1";
    public static final String RUNDECK_API_BASE = "/api/1";
    public static final String RUNDECK_API_EXECUTION_REPORT = "/api/1/report/create";
    public static final Logger logger = Logger.getLogger(RundeckCentralDispatcher.class);
    private ServerService serverService;
    private static Map<String, String> nodeFilterParams = new HashMap<String, String>();

    public RundeckCentralDispatcher(Framework framework) {
        this.serverService = new ServerService(framework);
    }

    @Override
    public void reportExecutionStatus(String project, String title, String status, int failedNodeCount, int successNodeCount, String tags, String script, String summary, Date start, Date end) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("project", project);
        params.put("title", title);
        params.put("status", status);
        params.put("nodesuccesscount", Integer.toString(successNodeCount));
        params.put("nodefailcount", Integer.toString(failedNodeCount));
        if (null != tags) {
            params.put("tags", tags);
        }
        if (null != script) {
            params.put("script", script);
        }
        params.put("summary", summary);
        if (null != start) {
            params.put("start", Long.toString(start.getTime()));
        }
        if (null != end) {
            params.put("end", Long.toString(end.getTime()));
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_API_EXECUTION_REPORT, params, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
    }

    @Override
    public QueuedItemResult queueDispatcherScript(IDispatchedScript iDispatchedScript) throws CentralDispatcherException {
        File tempxml;
        try {
            tempxml = File.createTempFile("dispatch", "xml");
            JobDefinitionSerializer.serializeToFile(iDispatchedScript, tempxml);
        }
        catch (IOException e) {
            throw new CentralDispatcherServerRequestException("Unable to queue command: " + e.getMessage(), e);
        }
        QueuedItemResult queuedItemResult = this.submitQueueRequest(tempxml, new HashMap<String, String>(), RUNDECK_EXEC_JOB_PATH);
        if (!tempxml.delete()) {
            logger.warn((Object)("Failed to delete temp file: " + tempxml.getAbsolutePath()));
        }
        return queuedItemResult;
    }

    private QueuedItemResult submitQueueRequest(File tempxml, HashMap<String, String> otherparams, String requestPath) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("xmlreq", "true");
        if (null != otherparams) {
            params.putAll(otherparams);
        }
        try {
            response = this.serverService.makeRundeckRequest(requestPath, params, tempxml, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document resultDoc = response.getResultDoc();
        Node node = resultDoc.selectSingleNode("/result/succeeded/@count");
        int succeeded = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = resultDoc.selectSingleNode("/result/failed/@count");
        int failed = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        if (succeeded > 0) {
            String id;
            logger.info((Object)("Succeeded queueing " + succeeded + " Job" + (succeeded > 1 ? "s" : "") + ":"));
            List nodes = resultDoc.selectNodes("/result/succeeded/execution");
            Node node1 = (Node)nodes.iterator().next();
            String index = node1.selectSingleNode("@index").getStringValue();
            String succeededId = id = node1.selectSingleNode("id").getStringValue();
            String name = node1.selectSingleNode("name").getStringValue();
            String url = node1.selectSingleNode("url").getStringValue();
            url = this.makeAbsoluteURL(url);
            logger.info((Object)("\t" + index + ": " + name + " [" + id + "] <" + url + ">"));
            return QueuedItemResultImpl.successful("Succeeded queueing " + name, succeededId, url, name);
        }
        if (failed > 0) {
            String s1 = "Failed to queue " + failed + " Job" + (failed > 1 ? "s" : "") + ":";
            logger.error((Object)s1);
            List nodes = resultDoc.selectNodes("/result/failed/execution");
            Node node1 = (Node)nodes.iterator().next();
            String index = node1.selectSingleNode("@index").getStringValue();
            String id = null != node1.selectSingleNode("id") ? node1.selectSingleNode("id").getStringValue() : null;
            String url = null != node1.selectSingleNode("url") ? node1.selectSingleNode("url").getStringValue() : null;
            url = this.makeAbsoluteURL(url);
            String error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : null;
            String message = null != node1.selectSingleNode("message") ? node1.selectSingleNode("message").getStringValue() : null;
            String errmsg = error + (null != id ? " [" + id + "] <" + url + ">" : "") + (null != message ? " : " + message : "");
            String s2 = index + ": " + errmsg;
            logger.error((Object)s2);
            return QueuedItemResultImpl.failed(errmsg);
        }
        return QueuedItemResultImpl.failed("Server response contained no success information.");
    }

    @Override
    public Collection<QueuedItem> listDispatcherQueue() throws CentralDispatcherException {
        return this.listDispatcherQueue(null);
    }

    @Override
    public Collection<QueuedItem> listDispatcherQueue(String project) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("xmlreq", "true");
        if (null != project) {
            params.put("projFilter", project);
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_LIST_EXECUTIONS_PATH, params, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document resultDoc = response.getResultDoc();
        Node node = resultDoc.selectSingleNode("/result/items");
        List items = node.selectNodes("item");
        ArrayList<QueuedItem> list = new ArrayList<QueuedItem>();
        if (null != items && items.size() > 0) {
            for (Object o : items) {
                Node node1 = (Node)o;
                String id = node1.selectSingleNode("id").getStringValue();
                String name = node1.selectSingleNode("name").getStringValue();
                String url = node1.selectSingleNode("url").getStringValue();
                url = this.makeAbsoluteURL(url);
                logger.info((Object)("\t: " + name + " [" + id + "] <" + url + ">"));
                list.add(QueuedItemResultImpl.createQueuedItem(id, url, name));
            }
        }
        return list;
    }

    String makeAbsoluteURL(String url) {
        if (null != url && url.startsWith("/")) {
            try {
                URL serverUrl = new URL(this.serverService.getConnParams().getServerUrl());
                URL newUrl = new URL(serverUrl, url);
                url = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    String makeContextAbsoluteURL(String url) {
        if (null != url && url.startsWith("/")) {
            try {
                URL newUrl = new URL(this.serverService.getConnParams().getServerUrl() + url);
                url = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private void validateJobsResponse(WebserviceResponse response) throws CentralDispatcherServerRequestException {
        Document resultDoc;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if (null == (resultDoc = response.getResultDoc())) {
            throw new CentralDispatcherServerRequestException("Response content unexpectedly empty");
        }
        try {
            logger.debug((Object)RundeckCentralDispatcher.serialize(resultDoc));
        }
        catch (IOException e) {
            logger.debug((Object)"ioexception serializing result doc", (Throwable)e);
        }
        if (!"joblist".equals(resultDoc.getRootElement().getName())) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content: " + resultDoc);
        }
    }

    private Envelope validateResponse(WebserviceResponse response) throws CentralDispatcherException {
        Document resultDoc;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if (null == (resultDoc = response.getResultDoc())) {
            throw new CentralDispatcherServerRequestException("Response content unexpectedly empty. " + (response.getResponseMessage() != null ? response.getResponseMessage() : ""));
        }
        try {
            logger.debug((Object)RundeckCentralDispatcher.serialize(resultDoc));
        }
        catch (IOException e) {
            logger.debug((Object)"ioexception serializing result doc", (Throwable)e);
        }
        if (!"result".equals(resultDoc.getRootElement().getName())) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content: " + resultDoc);
        }
        Envelope envelope = new Envelope(response.getResultDoc());
        if (envelope.isErrorResult()) {
            StringBuffer sb = new StringBuffer();
            StringBuffer buffer = envelope.errorMessages();
            if (buffer.length() > 0) {
                sb.append(buffer);
            } else {
                sb.append("Server reported an error");
                if (null != response.getResponseMessage()) {
                    sb.append(": ").append(response.getResponseMessage());
                }
            }
            if (null != response.getResponseMessage()) {
                logger.error((Object)("Server reported an error: " + response.getResponseMessage()));
            } else {
                logger.error((Object)"Server reported an error.");
            }
            throw new CentralDispatcherFailureResponseException(sb.toString());
        }
        return envelope;
    }

    @Override
    public DispatcherResult killDispatcherExecution(String execId) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", execId);
        params.put("xmlreq", "true");
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_KILL_JOB_PATH, params, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        Envelope envelope = this.validateResponse(response);
        final boolean result = envelope.isSuccessResult();
        final StringBuffer sb = envelope.successMessages();
        return new DispatcherResult(){

            public boolean isSuccessful() {
                return result;
            }

            public String getMessage() {
                return sb.toString();
            }
        };
    }

    @Override
    public ExecutionFollowResult followDispatcherExecution(String id, ExecutionFollowRequest request, ExecutionFollowReceiver receiver) throws CentralDispatcherException {
        throw new UnsupportedOperationException("Not supported: followDispatcherExecution");
    }

    private String createJobURL(String id) {
        return this.makeContextAbsoluteURL(RUNDECK_JOB_LINK_PREFIX + id);
    }

    @Override
    public Collection<IStoredJob> listStoredJobs(IStoredJobsQuery iStoredJobsQuery, OutputStream output, JobDefinitionFileFormat fformat) throws CentralDispatcherException {
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        String nameMatch = iStoredJobsQuery.getNameMatch();
        String groupMatch = iStoredJobsQuery.getGroupMatch();
        String projectFilter = iStoredJobsQuery.getProjectFilter();
        String idlistFilter = iStoredJobsQuery.getIdlist();
        if (null != output && null != fformat) {
            params.put("format", fformat.getName());
        } else {
            params.put("format", JobDefinitionFileFormat.xml.getName());
        }
        if (null != nameMatch) {
            params.put("jobFilter", nameMatch);
        }
        if (null != groupMatch) {
            Matcher matcher = Pattern.compile("^/*(.+?)/*$").matcher(groupMatch);
            if (matcher.matches()) {
                groupMatch = matcher.group(1);
            }
            params.put("groupPath", groupMatch);
        }
        if (null != projectFilter) {
            params.put("projFilter", projectFilter);
        }
        if (null != idlistFilter) {
            params.put("idlist", idlistFilter);
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_LIST_STORED_JOBS_PATH, params, null, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        if (null == fformat || fformat == JobDefinitionFileFormat.xml) {
            this.validateJobsResponse(response);
            Document resultDoc = response.getResultDoc();
            Node node = resultDoc.selectSingleNode("/joblist");
            ArrayList<IStoredJob> list = new ArrayList<IStoredJob>();
            if (null == node) {
                return list;
            }
            List items = node.selectNodes("job");
            if (null != items && items.size() > 0) {
                for (Object o : items) {
                    Node node1 = (Node)o;
                    String id = node1.selectSingleNode("id").getStringValue();
                    String name = node1.selectSingleNode("name").getStringValue();
                    String url = this.createJobURL(id);
                    Node gnode = node1.selectSingleNode("group");
                    String group = null != gnode ? gnode.getStringValue() : null;
                    String description = node1.selectSingleNode("description").getStringValue();
                    list.add(StoredJobImpl.create(id, name, url, group, description, projectFilter));
                }
            }
            if (null != output) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                try {
                    XMLWriter writer = new XMLWriter(output, format);
                    writer.write(resultDoc);
                    writer.flush();
                }
                catch (IOException e) {
                    throw new CentralDispatcherServerRequestException(e);
                }
            }
            return list;
        }
        if (fformat == JobDefinitionFileFormat.yaml) {
            Collection<Map> mapCollection = this.validateJobsResponseYAML(response);
            ArrayList<IStoredJob> list = new ArrayList<IStoredJob>();
            if (null == mapCollection || mapCollection.size() < 1) {
                return list;
            }
            for (Map map : mapCollection) {
                String id = map.get("id").toString();
                String name = (String)map.get("name");
                String group = map.containsKey("group") ? (String)map.get("group") : null;
                String desc = map.containsKey("description") ? (String)map.get("description") : "";
                String url = this.createJobURL(id);
                list.add(StoredJobImpl.create(id, name, url, group, desc, projectFilter));
            }
            if (null != output) {
                try {
                    Streams.copyStream(response.getResultStream(), output);
                }
                catch (IOException e) {
                    throw new CentralDispatcherServerRequestException(e);
                }
            }
            return list;
        }
        return null;
    }

    private Collection<Map> validateJobsResponseYAML(WebserviceResponse response) throws CentralDispatcherServerRequestException {
        Object resobj;
        String resultContentType;
        if (null == response) {
            throw new CentralDispatcherServerRequestException("Response was null");
        }
        if (null != response.getResponseMessage()) {
            logger.info((Object)("Response: " + response.getResponseMessage()));
        }
        if ((resultContentType = response.getResultContentType()).contains(";")) {
            resultContentType = resultContentType.substring(0, resultContentType.indexOf(";"));
        }
        if (!resultContentType.endsWith("/yaml")) {
            throw new CentralDispatcherServerRequestException("Expected YAML response, unexpected content type: " + response.getResultContentType());
        }
        ArrayList<Map> dataset = new ArrayList<Map>();
        try {
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
            resobj = yaml.load(response.getResultStream());
        }
        catch (YAMLException e) {
            throw new CentralDispatcherServerRequestException("Failed to parse YAML: " + e.getMessage(), (Exception)((Object)e));
        }
        if (!(resobj instanceof Collection)) {
            throw new CentralDispatcherServerRequestException("Response had unexpected content type: " + resobj);
        }
        dataset.addAll((Collection)resobj);
        for (Map map : dataset) {
            if (map.containsKey("name") && map.containsKey("id")) continue;
            throw new CentralDispatcherServerRequestException("Response had unexpected dataset: " + resobj);
        }
        return dataset;
    }

    @Override
    public QueuedItemResult queueDispatcherJob(IDispatchedJob dispatchedJob) throws CentralDispatcherException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (null == dispatchedJob.getJobRef()) {
            throw new IllegalArgumentException("JobRef was null");
        }
        if (null != dispatchedJob.getJobRef().getJobId()) {
            params.put("id", dispatchedJob.getJobRef().getJobId());
        } else {
            if (null != dispatchedJob.getJobRef().getName()) {
                params.put("jobName", dispatchedJob.getJobRef().getName());
            }
            if (null != dispatchedJob.getJobRef().getGroup()) {
                params.put("groupPath", dispatchedJob.getJobRef().getGroup());
            }
        }
        RundeckCentralDispatcher.addNodeSetParams(params, dispatchedJob.getNodeSet(), dispatchedJob.isKeepgoing(), "extra.");
        this.addLoglevelParams(params, dispatchedJob.getLoglevel(), "extra.");
        if (null != dispatchedJob.getArgs() && dispatchedJob.getArgs().length > 0) {
            params.put("extra.argString", CLIUtils.generateArgline(null, dispatchedJob.getArgs()));
        }
        return this.submitQueueRequest(null, params, RUNDECK_JOBS_RUN);
    }

    private void addLoglevelParams(Map<String, String> params, int loglevel, String prefix) {
        String loglevelstr = "INFO".toUpperCase();
        switch (loglevel) {
            case 4: {
                loglevelstr = "DEBUG".toUpperCase();
                break;
            }
            case 3: {
                loglevelstr = "VERBOSE".toUpperCase();
                break;
            }
            case 2: {
                loglevelstr = "INFO".toUpperCase();
                break;
            }
            case 1: {
                loglevelstr = "WARN".toUpperCase();
                break;
            }
            case 0: {
                loglevelstr = "ERR".toUpperCase();
            }
        }
        params.put(prefix + "loglevel", loglevelstr);
    }

    public static void addNodeSetParams(HashMap<String, String> params, NodeSet nodeSet, Boolean isKeepgoing, String prefix) {
        if (null == nodeSet) {
            return;
        }
        if (nodeSet.getThreadCount() > 0) {
            params.put(prefix + "nodeThreadcount", Integer.toString(nodeSet.getThreadCount()));
        }
        if (null != isKeepgoing) {
            params.put(prefix + "nodeKeepgoing", Boolean.toString(isKeepgoing));
        }
        if (nodeSet.isBlank()) {
            return;
        }
        params.put(prefix + "doNodedispatch", "true");
        boolean excludeprecedence = true;
        if (null != nodeSet.getExclude() && nodeSet.getExclude().isDominant()) {
            excludeprecedence = true;
        } else if (null != nodeSet.getInclude() && nodeSet.getInclude().isDominant()) {
            excludeprecedence = false;
        }
        params.put(prefix + "nodeExcludePrecedence", Boolean.toString(excludeprecedence));
        NodeSet.Include include = nodeSet.getInclude();
        for (NodeSet.FILTER_ENUM filter : NodeSet.FILTER_ENUM.values()) {
            String value = null;
            if (null != include && !include.isBlank()) {
                value = filter.value(include);
            }
            String key = nodeFilterParams.get(filter.getName());
            if (null != value && !"".equals(value)) {
                params.put(prefix + "nodeInclude" + key, value);
                continue;
            }
            params.put(prefix + "nodeInclude" + key, "");
        }
        NodeSet.Exclude exclude = nodeSet.getExclude();
        for (NodeSet.FILTER_ENUM filter : NodeSet.FILTER_ENUM.values()) {
            String value = null;
            if (null != exclude && !exclude.isBlank()) {
                value = filter.value(exclude);
            }
            String key = nodeFilterParams.get(filter.getName());
            if (null != value && !"".equals(value)) {
                params.put(prefix + "nodeExclude" + key, value);
                continue;
            }
            params.put(prefix + "nodeExclude" + key, "");
        }
    }

    @Override
    public Collection<IStoredJobLoadResult> loadJobs(ILoadJobsRequest iLoadJobsRequest, File input, JobDefinitionFileFormat format) throws CentralDispatcherException {
        IStoredJobLoadResult storedJobLoadResult;
        String error;
        Node node1;
        List nodes;
        WebserviceResponse response;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dupeOption", iLoadJobsRequest.getDuplicateOption().toString());
        params.put("xmlreq", "true");
        if (null != format) {
            params.put("fileformat", format.getName());
        }
        try {
            response = this.serverService.makeRundeckRequest(RUNDECK_JOBS_UPLOAD, params, input, null);
        }
        catch (MalformedURLException e) {
            throw new CentralDispatcherServerRequestException("Failed to make request", e);
        }
        this.validateResponse(response);
        Document result = response.getResultDoc();
        Node node = result.selectSingleNode("/result/succeeded/@count");
        int succeeded = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = result.selectSingleNode("/result/failed/@count");
        int failed = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        node = result.selectSingleNode("/result/skipped/@count");
        int skipped = null != node ? Integer.parseInt(node.getStringValue()) : -1;
        ArrayList<IStoredJobLoadResult> resultList = new ArrayList<IStoredJobLoadResult>();
        if (succeeded > 0) {
            logger.debug((Object)("Succeeded creating/updating " + succeeded + " Jobs:"));
            nodes = result.selectNodes("/result/succeeded/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                IStoredJobLoadResult storedJobLoadResult2 = this.parseStoredJobResult(node1, true, false, "Succeeded");
                resultList.add(storedJobLoadResult2);
            }
        }
        if (failed > 0) {
            logger.debug((Object)("Failed to add " + failed + " Jobs:"));
            nodes = result.selectNodes("/result/failed/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : "Failed";
                storedJobLoadResult = this.parseStoredJobResult(node1, false, false, error);
                resultList.add(storedJobLoadResult);
            }
        }
        if (skipped > 0) {
            logger.debug((Object)("Skipped " + skipped + " Jobs:"));
            nodes = result.selectNodes("/result/skipped/job");
            for (Object node2 : nodes) {
                node1 = (Node)node2;
                error = null != node1.selectSingleNode("error") ? node1.selectSingleNode("error").getStringValue() : "Skipped";
                storedJobLoadResult = this.parseStoredJobResult(node1, true, true, error);
                resultList.add(storedJobLoadResult);
            }
        }
        return resultList;
    }

    private IStoredJobLoadResult parseStoredJobResult(Node node1, boolean successful, boolean skippedJob, String message) {
        String index = node1.selectSingleNode("@index").getStringValue();
        Node idNode = node1.selectSingleNode("id");
        String id = null != idNode ? idNode.getStringValue() : null;
        String name = node1.selectSingleNode("name").getStringValue();
        Node urlNode = node1.selectSingleNode("url");
        String url = null != urlNode ? this.makeAbsoluteURL(urlNode.getStringValue()) : null;
        String group = null != node1.selectSingleNode("group") ? node1.selectSingleNode("group").getStringValue() : null;
        String description = null != node1.selectSingleNode("description") ? node1.selectSingleNode("description").getStringValue() : null;
        logger.debug((Object)("\t" + index + ": " + name + " [" + id + "] <" + url + ">"));
        return StoredJobLoadResultImpl.createLoadResult(id, name, url, group, description, successful, skippedJob, message);
    }

    private static String serialize(Document document) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        StringWriter sw = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)sw, format);
        writer.write(document);
        writer.flush();
        sw.flush();
        return sw.toString();
    }

    @Override
    public Collection<DeleteJobResult> deleteStoredJobs(Collection<String> jobIds) throws CentralDispatcherException {
        throw new CentralDispatcherException("Operation unsupported: No central dispatcher class is configured: framework.centraldispatcher.classname");
    }

    @Override
    public ExecutionDetail getExecution(String execId) throws CentralDispatcherException {
        throw new CentralDispatcherException("Operation unsupported: No central dispatcher class is configured: framework.centraldispatcher.classname");
    }

    static {
        nodeFilterParams.put("hostname", "");
        nodeFilterParams.put("type", "Type");
        nodeFilterParams.put("tags", "Tags");
        nodeFilterParams.put("os-name", "OsName");
        nodeFilterParams.put("os-family", "OsFamily");
        nodeFilterParams.put("os-arch", "OsArch");
        nodeFilterParams.put("os-version", "OsVersion");
        nodeFilterParams.put("name", "Name");
    }

    private static class Envelope {
        private Document doc;

        public Envelope(Document doc) {
            this.doc = doc;
        }

        public boolean isErrorResult() {
            Node node = this.doc.selectSingleNode("/result/@error");
            return null != node && "true".equals(node.getText());
        }

        public boolean isSuccessResult() {
            Node node = this.doc.selectSingleNode("/result/@success");
            return null == node || "true".equals(node.getText());
        }

        public StringBuffer successMessages() {
            return this.readMessages("/result/success/message");
        }

        public StringBuffer errorMessages() {
            return this.readMessages("/result/error/message");
        }

        private StringBuffer readMessages(String xpath) {
            StringBuffer sb = new StringBuffer();
            List errs = this.doc.selectNodes(xpath);
            if (null != errs) {
                for (Object err : errs) {
                    Node node = (Node)err;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(node.getStringValue());
                    logger.error((Object)("\t" + node.getStringValue()));
                }
            }
            return sb;
        }
    }
}

