/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.services;

import com.dtolabs.client.utils.HttpClientException;
import com.dtolabs.client.utils.WebserviceHttpClient;
import com.dtolabs.client.utils.WebserviceHttpClientFactory;
import com.dtolabs.client.utils.WebserviceResponse;
import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerService {
    private WebConnectionParameters connParams;

    public ServerService(final Framework framework) {
        this(new WebConnectionParameters(){

            public String getPassword() {
                return framework.getProperty("framework.server.password");
            }

            public String getUsername() {
                return framework.getProperty("framework.server.username");
            }

            public String getServerUrl() {
                return framework.getProperty("framework.rundeck.url");
            }
        });
    }

    public ServerService(WebConnectionParameters connParams) {
        this.connParams = connParams;
    }

    public WebserviceResponse makeRundeckRequest(String urlPath, Map queryParams, File uploadFile, String method) throws CoreException, MalformedURLException {
        return this.makeRundeckRequest(urlPath, queryParams, uploadFile, method, null);
    }

    public WebserviceResponse makeRundeckRequest(String urlPath, Map queryParams, Map<String, ? extends Object> formData) throws CoreException, MalformedURLException {
        return this.makeRundeckRequest(urlPath, queryParams, null, null, null, formData);
    }

    public WebserviceResponse makeRundeckRequest(String urlPath, Map queryParams, File uploadFile, String method, String expectedContentType) throws CoreException, MalformedURLException {
        return this.makeRundeckRequest(urlPath, queryParams, uploadFile, method, expectedContentType, null);
    }

    public WebserviceResponse makeRundeckRequest(String urlPath, Map queryParams, File uploadFile, String method, String expectedContentType, Map<String, ? extends Object> formData) throws CoreException, MalformedURLException {
        if (null == this.connParams) {
            throw new IllegalArgumentException("WebConnectionParameters must be specified");
        }
        URL jcUrl = new URL(this.connParams.getServerUrl());
        String jcBasePath = jcUrl.getPath();
        WebserviceHttpClient hc = null == formData ? WebserviceHttpClientFactory.getInstance().getWebserviceHttpClient(jcUrl + urlPath, jcBasePath, this.connParams.getUsername(), this.connParams.getPassword(), queryParams, uploadFile, "xmlBatch", null, expectedContentType) : WebserviceHttpClientFactory.getInstance().getWebserviceHttpClient(jcUrl + urlPath, jcBasePath, this.connParams.getUsername(), this.connParams.getPassword(), queryParams, formData);
        if (null != method) {
            hc.setMethodType(method);
        }
        try {
            hc.makeRequest();
        }
        catch (IOException e) {
            throw new CoreException("Error making server request to " + jcUrl + ": " + e.getMessage(), e);
        }
        catch (HttpClientException e) {
            throw new CoreException("Error making server request to " + jcUrl + ": " + e.getMessage(), e);
        }
        return hc;
    }

    public WebConnectionParameters getConnParams() {
        return this.connParams;
    }

    public void setConnParams(WebConnectionParameters connParams) {
        this.connParams = connParams;
    }

    public static interface WebConnectionParameters {
        public String getPassword();

        public String getUsername();

        public String getServerUrl();
    }
}

