/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.utils;

import com.dtolabs.client.utils.ClientState;
import com.dtolabs.client.utils.HttpAuthenticator;
import com.dtolabs.client.utils.HttpClientException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

class BasicAuthenticator
implements HttpAuthenticator {
    private String username;
    private String password;
    private static final String REALM_NAME = "Server";

    BasicAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean authenticate(URL reqUrl, HttpClient client) throws HttpClientException {
        AuthScope scope = new AuthScope(reqUrl.getHost(), reqUrl.getPort(), REALM_NAME);
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.getUsername(), this.getPassword());
        client.getParams().setAuthenticationPreemptive(true);
        if (client.getState().getCredentials(scope) == null) {
            client.getState().setCredentials(scope, (Credentials)creds);
        }
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean needsReAuthentication(int resultCode, HttpMethod method) {
        if (resultCode >= 300 && resultCode < 400) {
            ClientState.resetHttpState();
            return true;
        }
        return false;
    }

    private String getPassword() {
        return this.password;
    }
}

