/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.authorization.BaseAclsAuthorization;
import com.dtolabs.rundeck.core.authorization.JndiConfigParser;
import com.dtolabs.rundeck.core.authorization.LegacyAuthorization;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.jndi.Jndi;
import com.dtolabs.rundeck.core.jndi.JndiConfig;
import com.dtolabs.rundeck.core.utils.PropertyLookup;
import java.io.File;
import java.io.IOException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class JndiAuthorization
extends BaseAclsAuthorization
implements Authorization,
LegacyAuthorization {
    static final String JNDI_PROPFILE = "jndi.properties";
    private final Jndi jndi;
    static Logger logger = Logger.getLogger((String)JndiAuthorization.class.getName());

    public JndiAuthorization(Framework framework, File aclBaseDir) throws IOException, PoliciesParseException {
        this(framework, new File(framework.getConfigDir(), JNDI_PROPFILE), aclBaseDir);
    }

    public JndiAuthorization(Framework framework, File configFile, File aclBaseDir) throws IOException, PoliciesParseException {
        super(framework, aclBaseDir);
        PropertyLookup lookup = PropertyLookup.create(configFile);
        JndiConfigParser cp = new JndiConfigParser(lookup);
        JndiConfig cfg = cp.parse();
        try {
            logger.debug((Object)("Connecting to JNDI Server: " + cfg.getConnectionUrl()));
            this.jndi = new Jndi(cfg);
        }
        catch (NamingException e) {
            throw new AuthorizationException("Caught NameNotFoundException, error: " + e.getMessage() + ", Unable to connect to JNDI Server: " + cfg.getConnectionUrl() + " with connectionName: " + cfg.getConnectionName());
        }
        logger.debug((Object)this.toString());
    }

    public String[] determineUserRoles(String user) {
        String[] roles;
        try {
            logger.debug((Object)("obtaining list of roles for user: " + user));
            roles = this.jndi.getRoles(user);
        }
        catch (NamingException e) {
            logger.error((Object)("Unable to obtain role memberships for user: " + user));
            throw new AuthorizationException("Caught NamingException, error: " + e.getMessage() + ", Unable to obtain role memberships for user: " + user);
        }
        return roles;
    }

    public String toString() {
        return "JndiAuthorization{aclBasedir=" + this.getAclBasedir() + "}";
    }
}

