/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.ContextEvaluation;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextDecision
implements Explanation {
    private final Explanation.Code id;
    private final boolean granted;
    private final List<ContextEvaluation> evaluations;

    public ContextDecision(Explanation.Code id, boolean granted, List<ContextEvaluation> evaluations) {
        this.id = id;
        this.granted = granted;
        this.evaluations = evaluations;
    }

    public ContextDecision(Explanation.Code id, boolean granted) {
        this(id, granted, new ArrayList<ContextEvaluation>());
    }

    public boolean granted() {
        return this.granted;
    }

    @Override
    public Explanation.Code getCode() {
        return this.id;
    }

    @Override
    public void describe(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.granted() ? "GRANTED" : "REJECTED");
        sb.append(", reason: ");
        sb.append(this.id.toString());
        sb.append(", evaluations: ");
        if (null != this.evaluations && this.evaluations.size() > 0) {
            for (ContextEvaluation ce : this.evaluations) {
                sb.append("\t").append(ce.toString());
            }
        } else {
            sb.append("None");
        }
        return sb.toString();
    }

    List<ContextEvaluation> getEvaluations() {
        return this.evaluations;
    }
}

