/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.InvalidCollection;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.parsers.ParserConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policies {
    private final List<File> policyFiles = new ArrayList<File>();
    private PoliciesCache cache;

    public Policies(PoliciesCache cache) {
        this.cache = cache;
    }

    public int count() {
        int count = 0;
        for (PolicyCollection f : this.cache) {
            try {
                count = (int)((long)count + f.countPolicies());
            }
            catch (InvalidCollection e) {}
        }
        return count;
    }

    public static Policies load(File rootPath) throws IOException, PoliciesParseException {
        Policies p = null;
        try {
            p = new Policies(new PoliciesCache(rootPath));
        }
        catch (ParserConfigurationException e) {
            throw new PoliciesParseException(e);
        }
        return p;
    }

    public List<AclContext> narrowContext(Subject subject, Set<Attribute> environment) {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        for (PolicyCollection f : this.cache) {
            try {
                matchedContexts.addAll(f.matchedContexts(subject, environment));
            }
            catch (InvalidCollection e) {
                e.printStackTrace();
            }
        }
        return matchedContexts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(" [");
        Iterator<File> iter = this.policyFiles.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    @Deprecated
    public List<String> listAllRoles() {
        ArrayList<String> results = new ArrayList<String>();
        for (PolicyCollection f : this.cache) {
            try {
                results.addAll(f.groupNames());
            }
            catch (InvalidCollection e) {
                e.printStackTrace();
            }
        }
        return results;
    }
}

