/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.LdapGroup;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.InvalidCollection;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoliciesYaml
implements PolicyCollection {
    static Logger logger = Logger.getLogger((String)PoliciesYaml.class.getName());
    private final Set<YamlPolicy> all = new HashSet<YamlPolicy>();
    File file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoliciesYaml(File file) throws IOException {
        Yaml yaml = new Yaml();
        this.file = file;
        FileInputStream stream = new FileInputStream(this.file);
        int index = 1;
        try {
            for (Object yamlDoc : yaml.loadAll((InputStream)stream)) {
                Object yamlDoc1 = yamlDoc;
                if (yamlDoc1 instanceof Map) {
                    this.all.add(new YamlPolicy((Map)yamlDoc1, file, index));
                }
                ++index;
            }
        }
        finally {
            stream.close();
        }
    }

    @Override
    public Collection<String> groupNames() throws InvalidCollection {
        ArrayList<String> groups = new ArrayList<String>();
        for (YamlPolicy policy : this.all) {
            for (Object policyGroup : policy.getGroups()) {
                groups.add(policyGroup.toString());
            }
        }
        return groups;
    }

    @Override
    public long countPolicies() throws InvalidCollection {
        return this.all.size();
    }

    @Override
    public Collection<AclContext> matchedContexts(Subject subject, Set<Attribute> environment) throws InvalidCollection {
        return PoliciesYaml.policyMatcher(subject, this.all, environment, this.file);
    }

    static Collection<AclContext> policyMatcher(Subject subject, Collection<? extends Policy> policyLister, Set<Attribute> environment, File file) throws InvalidCollection {
        ArrayList<AclContext> matchedContexts = new ArrayList<AclContext>();
        int i = 0;
        for (Policy policy : policyLister) {
            Set<Group> groupPrincipals;
            Set<Username> userPrincipals;
            long userMatchStart = System.currentTimeMillis();
            if (null != policy.getEnvironment()) {
                EnvironmentalContext environment1 = policy.getEnvironment();
                if (!environment1.isValid()) {
                    logger.warn((Object)(policy.toString() + ": Context section not valid: " + environment1.toString()));
                }
                if (!environment1.matches(environment)) {
                    logger.debug((Object)(policy.toString() + ": environment not matched: " + environment1.toString()));
                    continue;
                }
            } else if (null != environment && environment.size() > 0) {
                logger.debug((Object)(policy.toString() + ": empty environment not matched"));
                continue;
            }
            if ((userPrincipals = subject.getPrincipals(Username.class)).size() > 0) {
                Set<String> policyUsers = policy.getUsernames();
                HashSet<String> usernamePrincipals = new HashSet<String>();
                for (Username username : userPrincipals) {
                    usernamePrincipals.add(username.getName());
                }
                if (!Collections.disjoint(policyUsers, usernamePrincipals)) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyUsers.size() > 0) {
                    logger.debug((Object)(policy.toString() + ": username not matched: " + policyUsers));
                }
            }
            if ((groupPrincipals = subject.getPrincipals(Group.class)).size() > 0) {
                long groupCollectStart = System.currentTimeMillis();
                Set<Object> policyGroups = policy.getGroups();
                HashSet<Object> groupNames = new HashSet<Object>();
                for (Group groupPrincipal : groupPrincipals) {
                    if (groupPrincipal instanceof LdapGroup) {
                        try {
                            groupNames.add(new LdapName(groupPrincipal.getName()));
                        }
                        catch (InvalidNameException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    groupNames.add(groupPrincipal.getName());
                }
                long collectDuration = System.currentTimeMillis() - groupCollectStart;
                if (!Collections.disjoint(policyGroups, groupNames)) {
                    matchedContexts.add(policy.getContext());
                    continue;
                }
                if (policyGroups.size() > 0) {
                    logger.debug((Object)(policy.toString() + ": group not matched: " + policyGroups));
                }
            }
            ++i;
        }
        logger.debug((Object)(file.getAbsolutePath() + ": matched contexts: " + matchedContexts.size()));
        return matchedContexts;
    }
}

