/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesDocument;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyNode
implements Policy {
    Node policyNode;
    HashSet<String> usernames;
    Set<Object> groups;

    public PolicyNode(Node policyNode) throws XPathExpressionException {
        this.policyNode = policyNode;
        this.init();
    }

    @Override
    public Set<String> getUsernames() {
        return this.usernames;
    }

    private void init() throws XPathExpressionException {
        this.initUsernames();
        this.initGroups();
    }

    private void initGroups() throws XPathExpressionException {
        NodeList groupNodes = (NodeList)PoliciesDocument.policyByGroup.evaluate(this.policyNode, XPathConstants.NODESET);
        this.groups = new HashSet<Object>(groupNodes.getLength());
        for (int g = 0; g < groupNodes.getLength(); ++g) {
            Node group = groupNodes.item(g);
            String ns = group.getNamespaceURI();
            if (ns == null) {
                this.groups.add(group.getNodeValue());
                continue;
            }
            if (!"http://dtolabs.com/rundeck/ldap".equalsIgnoreCase(ns) && !"http://dtolabs.com/rundeck/activedirectory".equalsIgnoreCase(ns)) continue;
            try {
                this.groups.add(new LdapName(group.getNodeValue()));
                continue;
            }
            catch (InvalidNameException e) {
                e.printStackTrace();
                continue;
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
        }
    }

    private void initUsernames() throws XPathExpressionException {
        NodeList usernameNodes = (NodeList)PoliciesDocument.policyByUserName.evaluate(this.policyNode, XPathConstants.NODESET);
        this.usernames = new HashSet(usernameNodes.getLength());
        for (int u = 0; u < usernameNodes.getLength(); ++u) {
            Node username = usernameNodes.item(u);
            this.usernames.add(username.getNodeValue());
        }
    }

    @Override
    public PoliciesDocument.Context getContext() {
        return new PoliciesDocument.Context(this.policyNode);
    }

    @Override
    public EnvironmentalContext getEnvironment() {
        return new EnvironmentalContext(){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public boolean matches(Set<Attribute> environment) {
                return true;
            }
        };
    }

    @Override
    public Set<Object> getGroups() {
        return this.groups;
    }
}

