/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.ContextDecision;
import com.dtolabs.rundeck.core.authorization.providers.Policies;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAREAuthorization
implements Authorization {
    private static final Logger logger = Logger.getLogger(SAREAuthorization.class);
    private final Policies policies;
    private final File baseDirectory;
    private long decisionsMade;

    public SAREAuthorization(File directory) throws IOException, PoliciesParseException {
        this.policies = Policies.load(directory);
        this.baseDirectory = directory;
    }

    public SAREAuthorization() throws IOException, PoliciesParseException {
        this(new File("/etc/rundeck/security.d/"));
    }

    private Decision internalEvaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        long start = System.currentTimeMillis();
        if (resource == null) {
            throw new IllegalArgumentException("Resource does not identify any resource because it's an empty resource property or null.");
        }
        for (Map.Entry<String, String> entry : resource.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Resource definition cannot contain null property name.");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("Resource definition cannot contain null value.  Corresponding key: " + entry.getKey());
        }
        if (subject == null) {
            throw new IllegalArgumentException("Invalid subject, subject is null.");
        }
        if (action == null || action.length() <= 0) {
            return SAREAuthorization.authorize(false, "No action provided.", Explanation.Code.REJECTED_NO_ACTION_PROVIDED, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        if (environment == null) {
            environment = Collections.emptySet();
        }
        ++this.decisionsMade;
        List<AclContext> contexts = this.policies.narrowContext(subject, environment);
        if (contexts.size() <= 0) {
            return SAREAuthorization.authorize(false, "No context matches subject or environment", Explanation.Code.REJECTED_NO_SUBJECT_OR_ENV_FOUND, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        ContextDecision contextDecision = null;
        ContextDecision lastDecision = null;
        boolean granted = false;
        boolean denied = false;
        for (AclContext ctx : contexts) {
            ContextDecision includes = ctx.includes(resource, action);
            if (Explanation.Code.REJECTED_DENIED == includes.getCode()) {
                contextDecision = includes;
                denied = true;
                return SAREAuthorization.createAuthorize(false, contextDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
            }
            if (includes.granted()) {
                contextDecision = includes;
                granted = true;
            }
            lastDecision = includes;
        }
        if (granted) {
            return SAREAuthorization.createAuthorize(true, contextDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        if (lastDecision == null) {
            return SAREAuthorization.authorize(false, "No resource or action matched.", Explanation.Code.REJECTED_NO_RESOURCE_OR_ACTION_MATCH, resource, subject, action, environment, System.currentTimeMillis() - start);
        }
        return SAREAuthorization.createAuthorize(false, lastDecision, resource, subject, action, environment, System.currentTimeMillis() - start);
    }

    @Override
    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        Decision decision = this.internalEvaluate(resource, subject, action, environment);
        StringBuilder sb = new StringBuilder();
        sb.append("Evaluating ").append(decision).append(" (").append(decision.evaluationDuration()).append("ms)");
        logger.info((Object)sb.toString());
        return decision;
    }

    @Override
    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
        HashSet<Decision> decisions = new HashSet<Decision>();
        long duration = 0L;
        for (Map<String, String> resource : resources) {
            for (String action : actions) {
                Decision decision = this.evaluate(resource, subject, action, environment);
                duration += decision.evaluationDuration();
                decisions.add(decision);
            }
        }
        return decisions;
    }

    private static Decision authorize(boolean authorized, final String reason, final Explanation.Code reasonId, Map<String, String> resource, Subject subject, String action, Set<Attribute> environment, long evaluationTime) {
        return SAREAuthorization.createAuthorize(authorized, new Explanation(){

            public Explanation.Code getCode() {
                return reasonId;
            }

            public void describe(PrintStream out) {
                out.println(this.toString());
            }

            public String toString() {
                return "\t" + reason + " => " + (Object)((Object)reasonId);
            }
        }, resource, subject, action, environment, evaluationTime);
    }

    private static Decision createAuthorize(final boolean authorized, final Explanation explanation, final Map<String, String> resource, final Subject subject, final String action, final Set<Attribute> environment, final long evaluationTime) {
        return new Decision(){
            private String representation;

            @Override
            public boolean isAuthorized() {
                return authorized;
            }

            @Override
            public Map<String, String> getResource() {
                return resource;
            }

            @Override
            public String getAction() {
                return action;
            }

            @Override
            public Set<Attribute> getEnvironment() {
                return environment;
            }

            @Override
            public Subject getSubject() {
                return subject;
            }

            public String toString() {
                if (this.representation == null) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Decision for: ");
                    builder.append("res<");
                    Iterator riter = resource.entrySet().iterator();
                    while (riter.hasNext()) {
                        Map.Entry s = riter.next();
                        builder.append((String)s.getKey()).append(':').append((String)s.getValue());
                        if (!riter.hasNext()) continue;
                        builder.append(", ");
                    }
                    builder.append("> subject<");
                    Iterator<Principal> iter = subject.getPrincipals().iterator();
                    while (iter.hasNext()) {
                        Principal principal = iter.next();
                        builder.append(principal.getClass().getSimpleName());
                        builder.append(':');
                        builder.append(principal.getName());
                        if (!iter.hasNext()) continue;
                        builder.append(' ');
                    }
                    builder.append("> action<");
                    builder.append(action);
                    builder.append("> env<");
                    Iterator eiter = environment.iterator();
                    while (eiter.hasNext()) {
                        Attribute a = (Attribute)eiter.next();
                        builder.append(a);
                        if (!eiter.hasNext()) continue;
                        builder.append(", ");
                    }
                    builder.append(">");
                    builder.append(": authorized: ");
                    builder.append(this.isAuthorized());
                    builder.append(": ");
                    builder.append(explanation.toString());
                    this.representation = builder.toString();
                }
                return this.representation;
            }

            @Override
            public Explanation explain() {
                return explanation;
            }

            @Override
            public long evaluationDuration() {
                return evaluationTime;
            }
        };
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.policies.count() + ") [" + this.baseDirectory.toString() + "]";
    }

    @Deprecated
    public List<String> hackMeSomeRoles() {
        return this.policies.listAllRoles();
    }
}

