/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionResult;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.commands.InterpreterResult;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import java.io.File;
import java.io.InputStream;

public class CLIExecutionListener
implements ExecutionListener {
    private FailedNodesListener failedNodesListener;
    private CLIToolLogger logger;
    private boolean terse;
    private int loglevel;
    private String logFormat;

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel) {
        this.failedNodesListener = failedNodesListener;
        this.logger = logger;
        this.loglevel = loglevel;
    }

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel, boolean terse) {
        this.failedNodesListener = failedNodesListener;
        this.logger = logger;
        this.loglevel = loglevel;
        this.terse = terse;
    }

    public CLIExecutionListener(FailedNodesListener failedNodesListener, CLIToolLogger logger, int loglevel, boolean terse, String logFormat) {
        this.failedNodesListener = failedNodesListener;
        this.logger = logger;
        this.loglevel = loglevel;
        this.terse = terse;
        this.logFormat = logFormat;
    }

    private boolean shouldlog(int level) {
        return level <= this.loglevel;
    }

    public void log(int level, String message) {
        if (this.shouldlog(level)) {
            if (level >= 4) {
                this.logger.verbose(message);
            } else if (level >= 3) {
                this.logger.verbose(message);
            } else if (level >= 2) {
                this.logger.log(message);
            } else if (level >= 1) {
                this.logger.warn(message);
            } else if (level >= 0) {
                this.logger.error(message);
            } else {
                this.logger.log(message);
            }
        }
    }

    public void beginExecution(ExecutionContext context, ExecutionItem item) {
    }

    public void finishExecution(ExecutionResult result, ExecutionContext context, ExecutionItem item) {
    }

    public void beginNodeExecution(ExecutionContext context, String[] command, INodeEntry node) {
    }

    public void finishNodeExecution(NodeExecutorResult result, ExecutionContext context, String[] command, INodeEntry node) {
    }

    public void beginNodeDispatch(ExecutionContext context, ExecutionItem item) {
    }

    public void finishNodeDispatch(DispatcherResult result, ExecutionContext context, ExecutionItem item) {
    }

    public void beginNodeDispatch(ExecutionContext context, Dispatchable item) {
    }

    public void finishNodeDispatch(DispatcherResult result, ExecutionContext context, Dispatchable item) {
    }

    public void beginFileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node) {
    }

    public void beginFileCopyFile(ExecutionContext context, File input, INodeEntry node) {
    }

    public void beginFileCopyScriptContent(ExecutionContext context, String input, INodeEntry node) {
    }

    public void finishFileCopy(String result, ExecutionContext context, INodeEntry node) {
    }

    public void beginInterpretCommand(ExecutionContext context, ExecutionItem item, INodeEntry node) {
    }

    public void finishInterpretCommand(InterpreterResult result, ExecutionContext context, ExecutionItem item, INodeEntry node) {
    }

    public FailedNodesListener getFailedNodesListener() {
        return this.failedNodesListener;
    }

    public boolean isTerse() {
        return this.terse;
    }

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String logFormat) {
        this.logFormat = logFormat;
    }
}

