/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIUtils {
    public static String generateArgline(String scriptpath, String[] args) {
        return CLIUtils.generateArgline(scriptpath, args, " ");
    }

    public static String generateArgline(String scriptpath, String[] args, String separator) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        if (null != scriptpath) {
            list.add(scriptpath);
        }
        if (null != args) {
            list.addAll(Arrays.asList(args));
        }
        for (String arg : list) {
            if (null == arg) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            if (arg.indexOf(" ") >= 0 && (0 != arg.indexOf("'") || arg.length() - 1 != arg.lastIndexOf("'"))) {
                sb.append("'").append(arg).append("'");
                continue;
            }
            sb.append(arg);
        }
        return sb.toString();
    }

    public static List<String> splitArgLine(String argline) {
        ArrayList<String> sb1 = new ArrayList<String>();
        String sqre = "(?:^'|\\s*')([^\\']+)(?:'$|'\\s*)";
        String dqre = "(?:^\"|\\s*\")([^\\\"]+)(?:\"$|\"\\s*)";
        String nospac = "(?:^|\\s*)(\\S+)(?:$|\\s*)";
        Matcher matcher = Pattern.compile("(?:^'|\\s*')([^\\']+)(?:'$|'\\s*)|(?:^\"|\\s*\")([^\\\"]+)(?:\"$|\"\\s*)|(?:^|\\s*)(\\S+)(?:$|\\s*)").matcher(argline);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                sb1.add(matcher.group(1));
                continue;
            }
            if (matcher.group(2) != null) {
                sb1.add(matcher.group(2));
                continue;
            }
            if (matcher.group(3) == null) continue;
            sb1.add(matcher.group(3));
        }
        return sb1;
    }
}

