/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class LoglevelOptions
implements CLIToolOptions {
    protected int currentLogLevel = 2;
    final Map<String, Integer> LOG_LEVELS = new HashMap<String, Integer>();
    final Map<Integer, String> LOG_LEVELS_REV = new HashMap<Integer, String>();
    public static final String LOGLEVEL_OPTION = "l";
    public static final String LEVEL_LONG = "level";
    public static final String VERBOSE_OPTION = "v";
    public static final String DEBUG_OPTION = "V";
    public static final String DEBUG = "debug";
    public static final String VERBOSE = "verbose";
    public static final String INFO = "info";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";

    public void addOptions(Options options) {
        options.addOption(LOGLEVEL_OPTION, LEVEL_LONG, true, "log level. debug|verbose|info|warning|error");
        this.LOG_LEVELS.put(DEBUG, 4);
        this.LOG_LEVELS_REV.put(4, DEBUG);
        this.LOG_LEVELS.put(VERBOSE, 3);
        this.LOG_LEVELS_REV.put(3, VERBOSE);
        this.LOG_LEVELS.put(INFO, 2);
        this.LOG_LEVELS_REV.put(2, INFO);
        this.LOG_LEVELS.put(WARNING, 1);
        this.LOG_LEVELS_REV.put(1, WARNING);
        this.LOG_LEVELS.put(ERROR, 0);
        this.LOG_LEVELS_REV.put(0, ERROR);
    }

    public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
        if (cli.hasOption(LOGLEVEL_OPTION)) {
            String argLevel = cli.getOptionValue(LOGLEVEL_OPTION);
            if (!this.LOG_LEVELS.containsKey(argLevel)) {
                throw new CLIToolOptionsException("unrecognized log level: " + argLevel);
            }
            this.currentLogLevel = this.LOG_LEVELS.get(argLevel);
        }
        if (cli.hasOption(VERBOSE_OPTION)) {
            this.currentLogLevel = 3;
        }
        if (cli.hasOption(DEBUG_OPTION)) {
            this.currentLogLevel = 4;
        }
    }

    public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
    }

    public int getLogLevel() {
        return this.currentLogLevel;
    }
}

