/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.FailedNodesFilestore;
import com.dtolabs.rundeck.core.utils.NodeSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFilterOptions
implements CLIToolOptions {
    static final String FILTER_EXCLUDE_PRECEDENCE_OPT = "Z";
    private boolean argKeepgoing;
    private boolean argKeepgoingSet;
    private int argThreadCount = -1;
    private File failedNodes;
    private Map<String, String> includeMap;
    private Map<String, String> excludeMap;
    private String argIncludeNodes;
    private String argExcludeNodes;
    private boolean argExcludePrecedence;
    static final String FILTER_EXCLUDE_PRECEDENCE_LONG = "filter-exclude-precedence";
    public static final String FILTER_INCLUDE = "I";
    public static final String FILTER_EXCLUDE = "X";
    public static final String FILTER_INCLUDE_LONG = "nodes";
    public static final String FILTER_EXCLUDE_LONG = "xnodes";
    public static final String THREADCOUNT = "C";
    public static final String THREADCOUNT_LONG = "threadcount";
    public static final String KEEPGOING = "K";
    public static final String KEEPGOING_LONG = "keepgoing";
    public static final String DONTKEEPGOING = "N";
    public static final String DONTKEEPGOING_LONG = "nokeepgoing";
    public static final String FAILEDNODES = "F";
    public static final String FAILEDNODES_LONG = "failednodes";
    private boolean includeFailednodes;

    public NodeFilterOptions(boolean includeFailednodes) {
        this.includeFailednodes = includeFailednodes;
    }

    public NodeFilterOptions() {
        this(false);
    }

    @Override
    public void addOptions(Options options) {
        options.addOption(THREADCOUNT, THREADCOUNT_LONG, true, "number of threads");
        options.addOption(FILTER_INCLUDE, FILTER_INCLUDE_LONG, true, "include node parameter list");
        options.addOption(FILTER_EXCLUDE, FILTER_EXCLUDE_LONG, true, "exclude node parameter list");
        options.addOption(KEEPGOING, KEEPGOING_LONG, false, "Continue node dispatch when execution on one node fails");
        options.addOption(DONTKEEPGOING, DONTKEEPGOING_LONG, false, "Force early failure if execution on one node fails");
        if (this.includeFailednodes) {
            options.addOption(FAILEDNODES, FAILEDNODES_LONG, true, "Filepath to store failed nodes");
        }
        options.addOption(FILTER_EXCLUDE_PRECEDENCE_OPT, FILTER_EXCLUDE_PRECEDENCE_LONG, true, "true/false. if true, exclusion filters have precedence over inclusion filters");
    }

    @Override
    public void parseArgs(CommandLine cli, String[] original) {
        if (cli.hasOption(DONTKEEPGOING)) {
            this.argKeepgoing = false;
            this.argKeepgoingSet = true;
        } else if (cli.hasOption(KEEPGOING)) {
            this.argKeepgoing = true;
            this.argKeepgoingSet = true;
        }
        if (cli.hasOption(THREADCOUNT)) {
            try {
                this.argThreadCount = Integer.valueOf(cli.getOptionValue(THREADCOUNT));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("threadcount must be an integer");
            }
        }
        if (cli.hasOption(FAILEDNODES)) {
            this.failedNodes = new File(cli.getOptionValue(FAILEDNODES));
        }
        boolean parsedFailedNodes = false;
        if (null != this.failedNodes && this.failedNodes.exists()) {
            this.includeMap = FailedNodesFilestore.parseFailedNodes(this.failedNodes);
            if (this.includeMap.size() > 0) {
                parsedFailedNodes = true;
            }
        }
        if (!parsedFailedNodes) {
            String[] keys = NodeSet.FILTER_KEYS_LIST.toArray(new String[NodeSet.FILTER_KEYS_LIST.size()]);
            this.excludeMap = this.parseExcludeArgs(keys, cli);
            this.includeMap = this.parseIncludeArgs(keys, cli);
        }
        if (cli.hasOption(FILTER_INCLUDE)) {
            this.argIncludeNodes = cli.getOptionValue(FILTER_INCLUDE);
        }
        if (cli.hasOption(FILTER_EXCLUDE)) {
            this.argExcludeNodes = cli.getOptionValue(FILTER_EXCLUDE);
        }
        this.argExcludePrecedence = NodeFilterOptions.determineExclusionPrecedenceForArgs(original, cli);
    }

    @Override
    public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
    }

    protected Map<String, String> parseExcludeArgs(String[] keys, CommandLine cli) {
        return NodeFilterOptions.parseFilterArgs(keys, cli, FILTER_EXCLUDE);
    }

    protected Map<String, String> parseIncludeArgs(String[] keys, CommandLine cli) {
        return NodeFilterOptions.parseFilterArgs(keys, cli, FILTER_INCLUDE);
    }

    protected static Map<String, String> parseFilterArgs(String[] keys, CommandLine cli, String opt) {
        String[] strings = cli.getOptionValues(opt);
        if ((null == strings || strings.length == 0) && null != cli.getOptionValue(opt)) {
            strings = new String[]{cli.getOptionValue(opt)};
        }
        return NodeFilterOptions.parseMultiNodeArgs(keys, strings);
    }

    protected static Map<String, String> parseMultiNodeArgs(String[] keys, String[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != values && values.length > 0) {
            for (String exclude : values) {
                int i1 = exclude.indexOf("=");
                if (i1 > 0 && i1 <= exclude.length() - 1) {
                    String k = exclude.substring(0, i1);
                    String v = exclude.substring(i1 + 1);
                    map.put(k, v);
                    continue;
                }
                if (i1 >= 0) continue;
                map.put(keys[0], exclude);
            }
        }
        return map;
    }

    public NodeSet getNodeSet() {
        NodeSet nodeset = new NodeSet();
        NodeSet.Include include = nodeset.createInclude(this.includeMap);
        include.setDominant(!this.argExcludePrecedence);
        NodeSet.Exclude exclude = nodeset.createExclude(this.excludeMap);
        exclude.setDominant(this.argExcludePrecedence);
        nodeset.setKeepgoing(this.argKeepgoing);
        nodeset.setThreadCount(this.argThreadCount);
        if (null != this.failedNodes) {
            nodeset.setFailedNodesfile(this.failedNodes);
        }
        return nodeset;
    }

    public boolean isKeepgoingSet() {
        return this.argKeepgoingSet;
    }

    static boolean determineExclusionPrecedenceForArgs(String[] args, CommandLine cli) {
        if (cli.hasOption(FILTER_EXCLUDE_PRECEDENCE_OPT)) {
            return "true".equals(cli.getOptionValue(FILTER_EXCLUDE_PRECEDENCE_OPT));
        }
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            if ("-X".equals(option) || "--xnodes".equals(option)) {
                return true;
            }
            if (!"-I".equals(option) && !"--nodes".equals(option)) continue;
            return false;
        }
        return true;
    }

    public String getArgIncludeNodes() {
        return this.argIncludeNodes;
    }

    public String getArgExcludeNodes() {
        return this.argExcludeNodes;
    }
}

