/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.project;

import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.project.BaseAction;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Category;

public class CreateAction
extends BaseAction {
    static Category logger = Category.getInstance((String)CreateAction.class.getName());
    private boolean cygwin;
    private Properties properties;

    public CreateAction(CLIToolLogger main, Framework framework, CommandLine cli) {
        this(main, framework, CreateAction.parseBaseActionArgs(cli), CreateAction.parseCreateActionArgs(cli));
    }

    public CreateAction(CLIToolLogger main, Framework framework, CommandLine cli, Properties properties) {
        this(main, framework, CreateAction.parseBaseActionArgs(cli), CreateAction.parseCreateActionArgs(cli), properties);
    }

    public CreateAction(CLIToolLogger main, Framework framework, BaseAction.BaseActionArgs baseArgs, CreateActionArgs createArgs, Properties projectProperties) {
        super(main, framework, baseArgs);
        this.properties = projectProperties;
        this.initArgs(createArgs);
    }

    public CreateAction(CLIToolLogger main, Framework framework, BaseAction.BaseActionArgs baseArgs, CreateActionArgs createArgs) {
        this(main, framework, baseArgs, createArgs, null);
    }

    public boolean isCygwin() {
        return this.cygwin;
    }

    public void setCygwin(boolean cygwin) {
        this.cygwin = cygwin;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static CreateActionArgs parseCreateActionArgs(CommandLine cli) {
        final boolean cygwin = cli.hasOption('G');
        return new CreateActionArgs(){

            public boolean isCygwin() {
                return cygwin;
            }
        };
    }

    public static CreateActionArgs createArgs(final boolean cygwin) {
        return new CreateActionArgs(){

            public boolean isCygwin() {
                return cygwin;
            }
        };
    }

    private void initArgs(CreateActionArgs args) {
        this.setCygwin(args.isCygwin());
    }

    public void exec() throws Throwable {
        super.exec();
        if (this.project == null) {
            throw new IllegalStateException("project was null");
        }
        File projectDir = new File(this.framework.getFrameworkProjectsBaseDir(), this.project.getFrameworkProject());
        this.main.verbose("project directory exists: " + projectDir.exists());
        try {
            this.main.verbose("creating project structure in: " + projectDir.getAbsolutePath() + "...");
            FrameworkProject.createFileStructure(projectDir);
            this.main.log("Project structure created: " + projectDir.getAbsolutePath());
        }
        catch (IOException e) {
            this.main.error(e.getMessage());
            throw new ProjectToolException("failed creating project structure", e);
        }
        this.main.verbose("initializing project: " + this.project.getFrameworkProject());
        FrameworkProject d = this.framework.getFrameworkProjectMgr().createFrameworkProject(this.project.getFrameworkProject(), this.properties);
        if (!d.getBaseDir().exists() && !d.getBaseDir().mkdir()) {
            throw new ProjectToolException("Failed to create project dir: " + d.getBaseDir());
        }
    }

    public static interface CreateActionArgs {
        public boolean isCygwin();
    }
}

