/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.queue;

import com.dtolabs.rundeck.core.dispatcher.ExecutionFollowReceiver;
import com.dtolabs.rundeck.core.execution.BaseLogger;
import java.io.PrintStream;

public class ConsoleExecutionFollowReceiver
implements ExecutionFollowReceiver {
    public static final long DEFAULT_INDETERMINATE_DELAY = 10000L;
    int percent;
    long time;
    int count;
    private final long averageDuration;
    Mode mode;
    PrintStream out;
    BaseLogger logger;
    String tickMark = "#";
    String tickMarkExtra = ".";

    public ConsoleExecutionFollowReceiver(long averageDuration, Mode mode, PrintStream out, BaseLogger logger) {
        this.averageDuration = averageDuration;
        this.percent = 0;
        this.time = 0L;
        this.count = 0;
        this.out = out;
        this.logger = logger;
        this.mode = mode;
    }

    public boolean receiveFollowStatus(long offset, long totalSize, long duration) {
        if (this.mode == Mode.progress && this.averageDuration >= 0L && this.percent > -1) {
            int mark = Math.round((float)duration / (float)this.averageDuration * 100.0f);
            int tick = 5;
            if (mark > this.percent) {
                int i;
                int diff;
                int z = 0;
                int x = 0;
                if (mark <= 100) {
                    diff = mark - this.percent + this.percent % tick;
                    z = diff / tick;
                }
                if (mark > 100 && this.percent < 100) {
                    diff = 100 - this.percent + this.percent % tick;
                    z = diff / tick;
                    this.percent = 100;
                }
                if (mark > 100) {
                    tick = 10;
                    diff = mark - this.percent + this.percent % tick;
                    x = diff / tick;
                }
                for (i = 0; i < z; ++i) {
                    this.out.print(this.tickMark);
                }
                for (i = 0; i < x; ++i) {
                    this.out.print(this.tickMarkExtra);
                }
                this.percent = mark;
                this.out.flush();
            }
        } else if (this.mode == Mode.progress && this.averageDuration < 0L) {
            long mark = System.currentTimeMillis();
            if (this.time <= 0L || this.time > 0L && mark - this.time > 10000L) {
                this.time = mark;
                ++this.count;
                this.out.print(".");
                if (this.count > 19) {
                    this.out.println();
                    this.count = 0;
                }
                this.out.flush();
            }
        }
        return true;
    }

    public boolean receiveLogEntry(String timeStr, String loglevel, String user, String command, String nodeName, String message) {
        if (this.mode == Mode.output || null == this.mode) {
            this.logger.log(message);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        output,
        progress,
        quiet;

    }
}

