/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.run;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.BaseTool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.DefaultCLIToolLogger;
import com.dtolabs.rundeck.core.cli.ExtendedOptions;
import com.dtolabs.rundeck.core.cli.FrameworkSingleProjectResolver;
import com.dtolabs.rundeck.core.cli.Log4JCLIToolLogger;
import com.dtolabs.rundeck.core.cli.LoglevelOptions;
import com.dtolabs.rundeck.core.cli.NodeFilterOptions;
import com.dtolabs.rundeck.core.cli.SingleProjectResolver;
import com.dtolabs.rundeck.core.cli.queue.ConsoleExecutionFollowReceiver;
import com.dtolabs.rundeck.core.cli.queue.QueueTool;
import com.dtolabs.rundeck.core.cli.run.RunToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedJob;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobRef;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.dispatcher.QueuedItemResult;
import com.dtolabs.rundeck.core.utils.NodeSet;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class RunTool
extends BaseTool {
    public static final Logger log4j = Logger.getLogger(RunTool.class);
    public static final String ACTION_RUN = "run";
    private Actions action = Actions.run;
    private CLIToolLogger clilogger;
    private final Framework framework;
    SingleProjectResolver internalResolver;
    private NodeFilterOptions nodefilterOptions;
    private LoglevelOptions loglevelOptions;
    private ExtendedOptions extendedOptions;
    private FollowOptions followOptions;
    Options runOptions;

    public Actions getAction() {
        return this.action;
    }

    public void setAction(Actions action) {
        this.action = action;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)Constants.getLog4jPropertiesFile().getAbsolutePath());
        RunTool tool = new RunTool(new DefaultCLIToolLogger());
        tool.setShouldExit(true);
        int exitCode = 1;
        try {
            tool.run(args);
            exitCode = 0;
        }
        catch (CLIToolOptionsException e) {
            exitCode = 2;
            tool.error(e.getMessage());
            tool.help();
        }
        catch (Throwable e) {
            if (e.getMessage() == null || tool.runOptions.argVerbose) {
                e.printStackTrace();
            }
            tool.error("Error: " + e.getMessage());
        }
        tool.exit(exitCode);
    }

    public RunTool() {
        this(Framework.getInstance(Constants.getSystemBaseDir()), new Log4JCLIToolLogger(log4j));
    }

    public RunTool(CLIToolLogger logger) {
        this(Framework.getInstance(Constants.getSystemBaseDir()), logger);
    }

    public RunTool(Framework framework) {
        this(framework, null);
    }

    public RunTool(Framework framework, CLIToolLogger logger) {
        this.framework = framework;
        this.internalResolver = new FrameworkSingleProjectResolver(framework);
        this.clilogger = logger;
        if (null == this.clilogger) {
            this.clilogger = new Log4JCLIToolLogger(log4j);
        }
        this.nodefilterOptions = new NodeFilterOptions(false);
        this.loglevelOptions = new LoglevelOptions();
        this.extendedOptions = new ExtendedOptions();
        this.followOptions = new FollowOptions();
        this.runOptions = new Options();
        this.addToolOptions(this.extendedOptions);
        this.addToolOptions(this.loglevelOptions);
        this.addToolOptions(this.nodefilterOptions);
        this.addToolOptions(this.followOptions);
        this.addToolOptions(this.runOptions);
    }

    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        CommandLine cli = super.parseArgs(args);
        if (args.length > 0 && !args[0].startsWith("-")) {
            try {
                this.action = Actions.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CLIToolOptionsException("Invalid action: " + args[0] + ", must be one of: " + Arrays.toString((Object[])Actions.values()));
            }
        }
        return cli;
    }

    protected void go() throws RunToolException, CLIToolOptionsException {
        switch (this.action) {
            case run: {
                this.jobrunAction();
                break;
            }
            default: {
                throw new CLIToolOptionsException("Unrecognized action: " + (Object)((Object)this.action));
            }
        }
    }

    private void jobrunAction() throws RunToolException {
        QueuedItemResult result;
        String jobname;
        String jobgroup;
        if (null != this.runOptions.argJob && this.runOptions.argJob.indexOf("/") >= 0) {
            Matcher m = Pattern.compile("^(/?(.*)/)?(.+)$").matcher(this.runOptions.argJob);
            if (m.matches()) {
                String gmatch = m.group(2);
                jobgroup = "".equals(gmatch) ? null : gmatch;
                jobname = m.group(3);
            } else {
                jobname = this.runOptions.argJob;
                jobgroup = null;
            }
        } else if (null != this.runOptions.argJob) {
            jobname = this.runOptions.argJob;
            jobgroup = null;
        } else {
            jobname = null;
            jobgroup = null;
        }
        final String project = this.runOptions.argProject;
        boolean argFollow = this.followOptions.argFollow;
        boolean argProgress = this.followOptions.argProgress;
        boolean argQuiet = this.followOptions.argQuiet;
        final NodeSet nodeset = this.nodefilterOptions.getNodeSet();
        final Boolean argKeepgoing = this.nodefilterOptions.isKeepgoingSet() ? Boolean.valueOf(nodeset.isKeepgoing()) : null;
        final int loglevel = this.loglevelOptions.getLogLevel();
        final String[] extraOpts = this.extendedOptions.getExtendedOptions();
        try {
            result = this.framework.getCentralDispatcherMgr().queueDispatcherJob(new IDispatchedJob(){

                @Override
                public String[] getArgs() {
                    return extraOpts;
                }

                @Override
                public int getLoglevel() {
                    return loglevel;
                }

                @Override
                public Map<String, Map<String, String>> getDataContext() {
                    return null;
                }

                @Override
                public NodeSet getNodeSet() {
                    return nodeset;
                }

                @Override
                public IStoredJobRef getJobRef() {
                    return new IStoredJobRef(){

                        public String getJobId() {
                            return RunTool.this.runOptions.argIdlist;
                        }

                        public String getName() {
                            return jobname;
                        }

                        public String getGroup() {
                            return jobgroup;
                        }

                        public String getProject() {
                            return project;
                        }
                    };
                }

                @Override
                public Boolean isKeepgoing() {
                    return argKeepgoing;
                }
            });
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to run a job: " + e.getMessage();
            throw new RunToolException(msg, e);
        }
        if (null == result || !result.isSuccessful()) {
            throw new RunToolException("Queued job request failed: " + (null != result ? result.getMessage() : "Result was null"));
        }
        QueuedItem queuedItem = result.getItem();
        this.log("Job execution started:");
        this.log("[" + queuedItem.getId() + "] " + queuedItem.getName() + " <" + queuedItem.getUrl() + ">");
        if (!argFollow) {
            return;
        }
        this.followOutput(queuedItem, argQuiet, argProgress);
    }

    private void followOutput(QueuedItem item, boolean quiet, boolean progress) throws RunToolException {
        boolean successful = false;
        try {
            ConsoleExecutionFollowReceiver.Mode mode = ConsoleExecutionFollowReceiver.Mode.output;
            if (quiet) {
                mode = ConsoleExecutionFollowReceiver.Mode.quiet;
            } else if (progress) {
                mode = ConsoleExecutionFollowReceiver.Mode.progress;
            }
            successful = QueueTool.followAction(item.getId(), true, mode, this.framework, System.out, this);
        }
        catch (CentralDispatcherException e) {
            throw new RunToolException("Failed following output for execution: " + item.getId(), e);
        }
        if (!successful) {
            this.exit(3);
        }
    }

    protected boolean isUseHelpOption() {
        return true;
    }

    public String getHelpString() {
        return "run : start running a Job on the server, and optionally follow the output\nrun -i <id>: Run a job by ID immediately\nrun -j <group/name>: Run a job by Name immediately. Group must be specified if name is not unique.\nrun -I <include> -X <exclude> [-i/-j ...]: Specify node filters and run a Job\nrun -i <id> -- <arguments...>: Specify commandline arguments to the Job\nrun -i <id> --follow -- <arguments...>: Print output of the job as it is received\nrun -i <id> --follow --progress -- <arguments...>: Follow progress of the job\nrun -i <id> --follow --quiet -- <arguments...>: Wait until job is done and exit with job status\n";
    }

    public void log(String output) {
        if (null != this.clilogger) {
            this.clilogger.log(output);
        }
    }

    public void error(String output) {
        if (null != this.clilogger) {
            this.clilogger.error(output);
        }
    }

    public void warn(String output) {
        if (null != this.clilogger) {
            this.clilogger.warn(output);
        }
    }

    public void verbose(String message) {
        if (null != this.clilogger) {
            this.clilogger.verbose(message);
        }
    }

    public void debug(String message) {
        if (null != this.clilogger) {
            this.clilogger.debug(message);
        }
    }

    class Options
    implements CLIToolOptions {
        public static final String ID_OPTION = "i";
        public static final String VERBOSE_OPTION = "v";
        public static final String ID_OPTION_LONG = "id";
        public static final String VERBOSE_OPTION_LONG = "verbose";
        public static final String JOB_OPTION = "j";
        public static final String JOB_OPTION_LONG = "job";
        public static final String PROJECT_OPTION = "p";
        public static final String PROJECT_OPTION_LONG = "project";
        String argIdlist;
        String argJob;
        boolean argVerbose;
        String argProject;

        Options() {
        }

        public void addOptions(org.apache.commons.cli.Options options) {
            options.addOption(ID_OPTION, ID_OPTION_LONG, true, "Job ID. Run the Job with this ID. ");
            options.addOption(JOB_OPTION, JOB_OPTION_LONG, true, "Job identifier (group and name).  Run a Job specified by Job name and optional group, e.g: 'Group Name/Job Name'. ");
            options.addOption(PROJECT_OPTION, PROJECT_OPTION_LONG, true, "Project name. Required if not specifying Job ID.");
            options.addOption(VERBOSE_OPTION, VERBOSE_OPTION_LONG, false, "Enable verbose output");
        }

        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(ID_OPTION)) {
                this.argIdlist = cli.getOptionValue(ID_OPTION);
            }
            if (cli.hasOption(VERBOSE_OPTION)) {
                this.argVerbose = true;
            }
            if (cli.hasOption(JOB_OPTION)) {
                this.argJob = cli.getOptionValue(JOB_OPTION);
            }
            if (cli.hasOption(PROJECT_OPTION)) {
                this.argProject = cli.getOptionValue(PROJECT_OPTION);
            }
        }

        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            switch (RunTool.this.action) {
                case run: {
                    this.validateRunAction();
                    break;
                }
                default: {
                    throw new CLIToolOptionsException("Unexpected action: " + (Object)((Object)RunTool.this.action));
                }
            }
        }

        public void validateRunAction() throws CLIToolOptionsException {
            if (null == this.argJob && null == this.argIdlist) {
                throw new CLIToolOptionsException("run action: -j/--job option or -i/--id is required");
            }
            if (null != this.argJob && null != this.argIdlist) {
                throw new CLIToolOptionsException("run action: -j/--job option and -i/--id cannot be combined, please specify only one.");
            }
            if (null != this.argJob && null == this.argProject) {
                if (RunTool.this.internalResolver.hasSingleProject()) {
                    this.argProject = RunTool.this.internalResolver.getSingleProjectName();
                    RunTool.this.debug("# No project specified, defaulting to: " + this.argProject);
                } else {
                    throw new CLIToolOptionsException("run action: -j/--job option requires -p/--project option");
                }
            }
        }
    }

    class FollowOptions
    implements CLIToolOptions {
        public static final String FOLLOW_OPTION = "f";
        public static final String FOLLOW_OPTION_LONG = "follow";
        public static final String QUIET_OPTION = "q";
        public static final String QUIET_OPTION_LONG = "quiet";
        public static final String PROGRESS_OPTION = "r";
        public static final String PROGRESS_OPTION_LONG = "progress";
        boolean argFollow;
        boolean argQuiet;
        boolean argProgress;

        FollowOptions() {
        }

        public void addOptions(org.apache.commons.cli.Options options) {
            options.addOption(FOLLOW_OPTION, FOLLOW_OPTION_LONG, false, "Follow Job output on commandline");
            options.addOption(QUIET_OPTION, QUIET_OPTION_LONG, false, "Quiet mode for following output.");
            options.addOption(PROGRESS_OPTION, PROGRESS_OPTION_LONG, false, "Following Job progress");
        }

        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            this.argFollow = cli.hasOption(FOLLOW_OPTION);
            this.argQuiet = cli.hasOption(QUIET_OPTION);
            this.argProgress = cli.hasOption(PROGRESS_OPTION);
        }

        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (!this.argQuiet && !this.argProgress || !this.argFollow) {
                // empty if block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Actions {
        run("run");

        private String name;

        private Actions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

