/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.IFrameworkResource;
import com.dtolabs.rundeck.core.common.IFrameworkResourceParent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FrameworkResource
implements IFrameworkResource {
    public static final String VALID_RESOURCE_NAME_REGEX = "^[-\\._a-zA-Z0-9+]+$";
    final Logger logger;
    private final String name;
    private final File baseDir;
    private IFrameworkResourceParent parent;

    public FrameworkResource(String name, File dir, IFrameworkResourceParent parent) {
        if ("".equals(name)) {
            throw new IllegalArgumentException("empty string cannot be used as a name");
        }
        this.name = name;
        this.baseDir = dir;
        this.parent = parent;
        this.logger = Logger.getLogger((String)this.getClass().getName());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public IFrameworkResourceParent getParent() {
        return this.parent;
    }

    public boolean isValid() {
        return this.getParent().childCouldBeLoaded(this.getName());
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeProperties(Properties props, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            props.store(fileOutputStream, "auto generated. do not edit.");
        }
        finally {
            fileOutputStream.close();
        }
    }
}

