/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.INodeBase;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodeFileParser;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import com.dtolabs.rundeck.core.common.NodesXMLParser;
import com.dtolabs.rundeck.core.common.NodesYamlParser;
import com.dtolabs.rundeck.core.utils.NodeSet;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nodes
implements NodeReceiver {
    static Logger logger = Logger.getLogger((String)Nodes.class.getName());
    private final File nodesFile;
    private final HashMap<String, INodeEntry> nodes;
    private final HashMap<String, INodeEntry> nodesByHostname;
    private boolean valid;
    private NodeFileParserException parserException;
    private final Format format;

    public boolean isValid() {
        return this.valid;
    }

    public NodeFileParserException getParserException() {
        return this.parserException;
    }

    protected Nodes(File nodesDataFile, Format format) throws NodeFileParserException {
        this.format = format;
        this.nodesFile = nodesDataFile;
        this.nodes = new HashMap();
        this.nodesByHostname = new HashMap();
        this.valid = false;
        if (!this.nodesFile.exists()) {
            logger.warn((Object)("nodes resource file doesn't exist: " + this.nodesFile.getAbsolutePath()));
            this.valid = true;
        } else {
            NodeFileParser parser = this.createParser(this.nodesFile);
            try {
                parser.parse();
                this.valid = true;
            }
            catch (NodeFileParserException e) {
                this.parserException = e;
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addFrameworkNode(FrameworkProject project) {
        String fwkNode = project.getFrameworkProjectMgr().getFramework().getFrameworkNodeName();
        if (null == this.nodes.get(fwkNode)) {
            this.nodes.put(fwkNode, project.getFrameworkProjectMgr().getFramework().createFrameworkNode());
        }
    }

    public static Nodes create(File nodesFile, Format format) throws NodeFileParserException {
        return new Nodes(nodesFile, format);
    }

    public File getFile() {
        return this.nodesFile;
    }

    public Collection<INodeEntry> listNodes() {
        ArrayList<INodeEntry> l = new ArrayList<INodeEntry>(this.nodes.values());
        Collections.sort(l, new NodeEntryComparator());
        return l;
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public boolean hasNode(String name) {
        return this.nodes.containsKey(name);
    }

    public boolean hasNodeByHostname(String hostname) {
        return this.nodesByHostname.containsKey(hostname);
    }

    public INodeEntry getNode(String name) {
        return this.nodes.get(name);
    }

    public INodeEntry getNodeByHostname(String hostname) {
        return this.nodesByHostname.get(hostname);
    }

    @Override
    public void putNode(INodeEntry iNodeEntry) {
        this.nodes.put(iNodeEntry.getNodename(), iNodeEntry);
        this.nodesByHostname.put(iNodeEntry.getHostname(), iNodeEntry);
    }

    protected NodeFileParser createParser(File propfile) {
        switch (this.format) {
            case resourcexml: {
                return new NodesXMLParser(propfile, (NodeReceiver)this);
            }
            case resourceyaml: {
                return new NodesYamlParser(propfile, (NodeReceiver)this);
            }
        }
        throw new IllegalArgumentException("Nodes resource file format not valid: " + (Object)((Object)this.format));
    }

    public Collection<INodeEntry> filterNodes(Collection<? extends INodeBase> nodeEntries, NodeSet nodeSet) {
        ArrayList<INodeEntry> list = new ArrayList<INodeEntry>();
        for (INodeBase iNodeBase : nodeEntries) {
            INodeEntry entry = this.getNode(iNodeBase.getNodename());
            if (null == entry || null != nodeSet && nodeSet.shouldExclude(entry)) continue;
            list.add(entry);
        }
        return list;
    }

    public Collection<INodeEntry> getNodeEntries(Collection<? extends INodeBase> nodenames) {
        ArrayList<INodeEntry> list = new ArrayList<INodeEntry>();
        for (INodeBase iNodeBase : nodenames) {
            INodeEntry entry = this.getNode(iNodeBase.getNodename());
            if (null == entry) continue;
            list.add(entry);
        }
        return list;
    }

    public Collection<INodeEntry> filterNodes(NodeSet nodeset) {
        return this.filterNodes(this.listNodes(), nodeset);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Nodes{");
        for (INodeEntry node : this.nodes.values()) {
            sb.append(node.toString());
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeEntryComparator
    implements Comparator<INodeBase>,
    Serializable {
        @Override
        public int compare(INodeBase nodeA, INodeBase nodeB) {
            return nodeA.getNodename().compareTo(nodeB.getNodename());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        resourcexml,
        resourceyaml;

    }
}

