/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;

public class SelectorUtils {
    public static NodesSelector and(NodesSelector a, NodesSelector b) {
        return new AndNodesSelector(a, b);
    }

    public static NodesSelector or(NodesSelector a, NodesSelector b) {
        return new OrNodesSelector(a, b);
    }

    public static NodesSelector singleNode(String nodename) {
        return new SingleNodeSelector(nodename);
    }

    public static class SingleNodeSelector
    implements NodesSelector {
        private final String nodename;

        public SingleNodeSelector(String nodename) {
            this.nodename = nodename;
        }

        public boolean acceptNode(INodeEntry entry) {
            return this.nodename.equals(entry.getNodename());
        }

        public String toString() {
            return "SingleNodeSelector{nodename='" + this.nodename + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleNodeSelector that = (SingleNodeSelector)o;
            return !(this.nodename != null ? !this.nodename.equals(that.nodename) : that.nodename != null);
        }

        public int hashCode() {
            return this.nodename != null ? this.nodename.hashCode() : 0;
        }
    }

    public static class OrNodesSelector
    extends ChainNodesSelector {
        public OrNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            super(aselector, bselector);
        }

        public boolean acceptNode(INodeEntry entry) {
            return this.aselector.acceptNode(entry) || this.bselector.acceptNode(entry);
        }
    }

    public static class AndNodesSelector
    extends ChainNodesSelector {
        public AndNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            super(aselector, bselector);
        }

        public boolean acceptNode(INodeEntry entry) {
            return this.aselector.acceptNode(entry) && this.bselector.acceptNode(entry);
        }
    }

    private static abstract class ChainNodesSelector
    implements NodesSelector {
        NodesSelector aselector;
        NodesSelector bselector;

        public ChainNodesSelector(NodesSelector aselector, NodesSelector bselector) {
            this.aselector = aselector;
            this.bselector = bselector;
        }
    }
}

