/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.FileUpdater;
import com.dtolabs.rundeck.core.common.FileUpdaterException;
import com.dtolabs.rundeck.core.common.URLFileUpdaterFactory;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.log4j.Logger;

public class UpdateUtils {
    private static Logger logger = Logger.getLogger(UpdateUtils.class);

    public static void updateFileFromUrl(String sourceUrl, String destinationFilePath) throws UpdateException {
        UpdateUtils.updateFileFromUrl(sourceUrl, destinationFilePath, null, null);
    }

    public static void updateFileFromFile(File sourceFile, String destinationFilePath) throws UpdateException {
        if (!sourceFile.exists()) {
            throw new UpdateException("Source file does not exist: " + sourceFile);
        }
        if (!sourceFile.isFile()) {
            throw new UpdateException("Not a file: " + sourceFile);
        }
        if (sourceFile.length() < 1L) {
            throw new UpdateException("Source file is empty: " + sourceFile);
        }
        try {
            UpdateUtils.updateFileFromInputStream(new FileInputStream(sourceFile), destinationFilePath);
        }
        catch (IOException e) {
            throw new UpdateException("Unable to update file: " + e.getMessage(), e);
        }
    }

    public static void updateFileFromInputStream(InputStream input, String destinationFilePath) throws UpdateException {
        UpdateUtils.update(new FileStreamUpdater(input), new File(destinationFilePath));
    }

    private static void moveFile(File fromFile, File toFile) throws UpdateException {
        if (!fromFile.renameTo(toFile)) {
            String osName1 = System.getProperty("os.name");
            if (osName1.toLowerCase().indexOf("windows") > -1 && toFile.exists()) {
                if (!toFile.delete()) {
                    throw new UpdateException("Unable to remove dest file on windows: " + toFile);
                }
                if (!fromFile.renameTo(toFile)) {
                    throw new UpdateException("Unable to move temp file to dest file on windows: " + fromFile + ", " + toFile);
                }
            } else {
                throw new UpdateException("Unable to move temp file to dest file: " + fromFile + ", " + toFile);
            }
        }
    }

    public static void updateFileFromUrl(String sourceUrl, String destinationFilePath, String username, String password) throws UpdateException {
        UpdateUtils.updateFileFromUrl(sourceUrl, destinationFilePath, username, password, URLFileUpdater.factory());
    }

    public static void updateFileFromUrl(String sourceUrl, String destinationFilePath, String username, String password, URLFileUpdaterFactory factory) throws UpdateException {
        URL url;
        String tusername = username;
        String tpassword = password;
        try {
            String userInfo;
            String[] split;
            url = new URL(sourceUrl);
            if (null == username && null == password && null != url.getUserInfo() && 2 == (split = (userInfo = url.getUserInfo()).split(":", 2)).length) {
                tusername = split[0];
                tpassword = split[1];
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile());
            }
        }
        catch (MalformedURLException e) {
            throw new UpdateException(e);
        }
        File destinationFile = new File(destinationFilePath);
        long mtime = destinationFile.exists() ? destinationFile.lastModified() : 0L;
        UpdateUtils.update(factory.fileUpdaterFromURL(url, tusername, tpassword), destinationFile);
        if (destinationFile.lastModified() > mtime) {
            logger.info((Object)("updated file: " + destinationFile.getAbsolutePath()));
        } else {
            logger.info((Object)("file already up to date: " + destinationFile.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(FileUpdater updater, File destFile) throws UpdateException {
        File lockFile = new File(destFile.getAbsolutePath() + ".lock");
        File newDestFile = new File(destFile.getAbsolutePath() + ".new");
        try {
            Class<UpdateUtils> clazz = UpdateUtils.class;
            synchronized (UpdateUtils.class) {
                block12: {
                    FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
                    FileLock lock = channel.lock();
                    try {
                        FileUtils.copyFileStreams(destFile, newDestFile);
                        if (!newDestFile.setLastModified(destFile.lastModified())) {
                            logger.warn((Object)("Unable to set modification time of temp file: " + newDestFile.getAbsolutePath()));
                        }
                        updater.updateFile(newDestFile);
                        if (newDestFile.isFile() && newDestFile.length() > 0L) {
                            UpdateUtils.moveFile(newDestFile, destFile);
                            break block12;
                        }
                        throw new UpdateException("Result file was empty or not present: " + newDestFile);
                    }
                    catch (FileUpdaterException e) {
                        throw new UpdateException(e);
                    }
                    finally {
                        lock.release();
                        channel.close();
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new UpdateException("Unable to get and write file: " + e.getMessage(), e);
        }
        {
            return;
        }
    }

    private static class FileStreamUpdater
    implements FileUpdater {
        InputStream input;

        public FileStreamUpdater(InputStream input) {
            this.input = input;
        }

        public void updateFile(File destinationFile) throws FileUpdaterException {
            try {
                Streams.copyStream(this.input, new FileOutputStream(destinationFile));
            }
            catch (IOException e) {
                throw new FileUpdaterException(e);
            }
        }
    }

    public static class UpdateException
    extends Exception {
        public UpdateException() {
        }

        public UpdateException(String s) {
            super(s);
        }

        public UpdateException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public UpdateException(Throwable throwable) {
            super(throwable);
        }
    }
}

