/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextImpl
implements ExecutionContext {
    private String frameworkProject;
    private String user;
    private NodesSelector nodeSet;
    private int threadCount;
    private boolean keepgoing;
    private String[] args;
    private int loglevel;
    private Map<String, Map<String, String>> dataContext;
    private Map<String, Map<String, String>> privateDataContext;
    private ExecutionListener executionListener;
    private Framework framework;
    private File nodesFile;
    private String nodeRankAttribute;
    private boolean nodeRankOrderAscending = true;

    private ExecutionContextImpl(Builder builder) {
        this.frameworkProject = builder.frameworkProject;
        this.user = builder.user;
        this.nodeSet = builder.nodeSet;
        this.args = builder.args;
        this.loglevel = builder.loglevel;
        this.dataContext = builder.dataContext;
        this.privateDataContext = builder.privateDataContext;
        this.executionListener = builder.executionListener;
        this.framework = builder.framework;
        this.nodesFile = builder.nodesFile;
        this.threadCount = builder.threadCount;
        this.keepgoing = builder.keepgoing;
        this.nodeRankAttribute = builder.nodeRankAttribute;
        this.nodeRankOrderAscending = builder.nodeRankOrderAscending;
    }

    @Override
    public String getFrameworkProject() {
        return this.frameworkProject;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public NodesSelector getNodeSelector() {
        return this.nodeSet;
    }

    @Override
    public String[] getArgs() {
        return null != this.args ? (String[])this.args.clone() : null;
    }

    @Override
    public int getLoglevel() {
        return this.loglevel;
    }

    @Override
    public Map<String, Map<String, String>> getDataContext() {
        return this.dataContext;
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public File getNodesFile() {
        return this.nodesFile;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isKeepgoing() {
        return this.keepgoing;
    }

    @Override
    public Map<String, Map<String, String>> getPrivateDataContext() {
        return this.privateDataContext;
    }

    @Override
    public String getNodeRankAttribute() {
        return this.nodeRankAttribute;
    }

    @Override
    public boolean isNodeRankOrderAscending() {
        return this.nodeRankOrderAscending;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String frameworkProject;
        private String user;
        private NodesSelector nodeSet;
        private String[] args;
        private int loglevel;
        private Map<String, Map<String, String>> dataContext;
        private Map<String, Map<String, String>> privateDataContext;
        private ExecutionListener executionListener;
        private Framework framework;
        private File nodesFile;
        private int threadCount;
        private boolean keepgoing;
        private String nodeRankAttribute;
        private boolean nodeRankOrderAscending = true;

        public Builder() {
        }

        public Builder(ExecutionContext original) {
            this.frameworkProject = original.getFrameworkProject();
            this.user = original.getUser();
            this.nodeSet = original.getNodeSelector();
            this.args = original.getArgs();
            this.loglevel = original.getLoglevel();
            this.dataContext = original.getDataContext();
            this.privateDataContext = original.getPrivateDataContext();
            this.executionListener = original.getExecutionListener();
            this.framework = original.getFramework();
            this.nodesFile = original.getNodesFile();
            this.threadCount = original.getThreadCount();
            this.keepgoing = original.isKeepgoing();
            this.nodeRankAttribute = original.getNodeRankAttribute();
            this.nodeRankOrderAscending = original.isNodeRankOrderAscending();
        }

        public Builder frameworkProject(String frameworkProject) {
            this.frameworkProject = frameworkProject;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder nodeSelector(NodesSelector nodeSet) {
            this.nodeSet = nodeSet;
            return this;
        }

        public Builder args(String[] args) {
            this.args = args;
            return this;
        }

        public Builder loglevel(int loglevel) {
            this.loglevel = loglevel;
            return this;
        }

        public Builder dataContext(Map<String, Map<String, String>> dataContext) {
            this.dataContext = dataContext;
            return this;
        }

        public Builder privateDataContext(Map<String, Map<String, String>> privateDataContext) {
            this.privateDataContext = privateDataContext;
            return this;
        }

        public Builder executionListener(ExecutionListener executionListener) {
            this.executionListener = executionListener;
            return this;
        }

        public Builder framework(Framework framework) {
            this.framework = framework;
            return this;
        }

        public Builder nodesFile(File nodesFile) {
            this.nodesFile = nodesFile;
            return this;
        }

        public Builder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public Builder keepgoing(boolean keepgoing) {
            this.keepgoing = keepgoing;
            return this;
        }

        public Builder nodeRankAttribute(String nodeRankAttribute) {
            this.nodeRankAttribute = nodeRankAttribute;
            return this;
        }

        public Builder nodeRankOrderAscending(boolean nodeRankOrderAscending) {
            this.nodeRankOrderAscending = nodeRankOrderAscending;
            return this;
        }

        public ExecutionContextImpl build() {
            return new ExecutionContextImpl(this);
        }
    }
}

