/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.BaseExecutionResult;
import com.dtolabs.rundeck.core.execution.ContextLoggerExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionResult;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.commands.CommandInterpreter;
import com.dtolabs.rundeck.core.execution.commands.InterpreterException;
import com.dtolabs.rundeck.core.execution.commands.InterpreterResult;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.utils.FormattedOutputStream;
import com.dtolabs.rundeck.core.utils.LogReformatter;
import com.dtolabs.rundeck.core.utils.MapGenerator;
import com.dtolabs.rundeck.core.utils.ThreadBoundOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class ExecutionServiceImpl
implements ExecutionService {
    private final Framework framework;

    public ExecutionServiceImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult executeItem(ExecutionContext context, ExecutionItem item) throws ExecutionException {
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginExecution(context, item);
        }
        boolean success = false;
        DispatcherResult result = null;
        BaseExecutionResult baseExecutionResult = null;
        try {
            result = this.dispatchToNodes(context, item);
            success = result.isSuccess();
            baseExecutionResult = new BaseExecutionResult(result, success, null);
        }
        catch (DispatcherException e) {
            baseExecutionResult = new BaseExecutionResult(result, success, e);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishExecution(baseExecutionResult, context, item);
            }
        }
        return baseExecutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResult interpretCommand(ExecutionContext context, ExecutionItem item, INodeEntry node) throws InterpreterException {
        CommandInterpreter interpreter;
        try {
            interpreter = this.framework.getCommandInterpreterForItem(item);
        }
        catch (ExecutionServiceException e) {
            throw new InterpreterException(e);
        }
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginInterpretCommand(context, item, node);
        }
        InterpreterResult result = null;
        try {
            result = interpreter.interpretCommand(context, item, node);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishInterpretCommand(result, context, item, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherResult dispatchToNodes(ExecutionContext context, ExecutionItem item) throws DispatcherException {
        NodeDispatcher dispatcher;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeDispatch(context, item);
        }
        try {
            dispatcher = this.framework.getNodeDispatcherForContext(context);
        }
        catch (ExecutionServiceException e) {
            throw new DispatcherException(e);
        }
        DispatcherResult result = null;
        try {
            result = dispatcher.dispatch(context, item);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeDispatch(result, context, item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherResult dispatchToNodes(ExecutionContext context, Dispatchable item) throws DispatcherException {
        NodeDispatcher dispatcher;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeDispatch(context, item);
        }
        try {
            dispatcher = this.framework.getNodeDispatcherForContext(context);
        }
        catch (ExecutionServiceException e) {
            throw new DispatcherException(e);
        }
        DispatcherResult result = null;
        try {
            result = dispatcher.dispatch(context, item);
        }
        finally {
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeDispatch(result, context, item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileCopyFileStream(ExecutionContext context, InputStream input, INodeEntry node) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFileStream(context, input, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e);
        }
        LogReformatter formatter = ExecutionServiceImpl.createLogReformatter(node, context.getExecutionListener());
        ThreadStreamFormatter loggingReformatter = new ThreadStreamFormatter(formatter).invoke();
        String result = null;
        try {
            result = copier.copyFileStream(context, input, node);
        }
        finally {
            loggingReformatter.resetOutputStreams();
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileCopyFile(ExecutionContext context, File file, INodeEntry node) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyFile(context, file, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e);
        }
        LogReformatter formatter = ExecutionServiceImpl.createLogReformatter(node, context.getExecutionListener());
        ThreadStreamFormatter loggingReformatter = new ThreadStreamFormatter(formatter).invoke();
        String result = null;
        try {
            result = copier.copyFile(context, file, node);
        }
        finally {
            loggingReformatter.resetOutputStreams();
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileCopyScriptContent(ExecutionContext context, String script, INodeEntry node) throws FileCopierException {
        FileCopier copier;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginFileCopyScriptContent(context, script, node);
        }
        try {
            copier = this.framework.getFileCopierForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new FileCopierException(e);
        }
        LogReformatter formatter = ExecutionServiceImpl.createLogReformatter(node, context.getExecutionListener());
        ThreadStreamFormatter loggingReformatter = new ThreadStreamFormatter(formatter).invoke();
        String result = null;
        try {
            result = copier.copyScriptContent(context, script, node);
        }
        finally {
            loggingReformatter.resetOutputStreams();
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishFileCopy(result, context, node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) throws ExecutionException {
        NodeExecutor nodeExecutor;
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().beginNodeExecution(context, command, node);
        }
        try {
            nodeExecutor = this.framework.getNodeExecutorForNodeAndProject(node, context.getFrameworkProject());
        }
        catch (ExecutionServiceException e) {
            throw new ExecutionException(e);
        }
        Map<String, Map<String, String>> nodeDataContext = DataContextUtils.addContext("node", DataContextUtils.nodeData(node), context.getDataContext());
        String[] nodeCommand = DataContextUtils.replaceDataReferences(command, nodeDataContext);
        LogReformatter formatter = ExecutionServiceImpl.createLogReformatter(node, context.getExecutionListener());
        ThreadStreamFormatter loggingReformatter = new ThreadStreamFormatter(formatter).invoke();
        NodeExecutorResult result = null;
        try {
            ExecutionContextImpl nodeContext = new ExecutionContextImpl.Builder(context).dataContext(nodeDataContext).build();
            result = nodeExecutor.executeCommand(nodeContext, nodeCommand, node);
        }
        finally {
            loggingReformatter.resetOutputStreams();
            if (null != context.getExecutionListener()) {
                context.getExecutionListener().finishNodeExecution(result, context, command, node);
            }
        }
        return result;
    }

    public String getName() {
        return "ExecutionService";
    }

    public static LogReformatter createLogReformatter(INodeEntry node, ExecutionListener listener) {
        LogReformatter gen;
        if (null != listener && listener.isTerse()) {
            gen = null;
        } else {
            String logformat = "[%user@%node %command][%level] %message";
            if (null != listener && null != listener.getLogFormat()) {
                logformat = listener.getLogFormat();
            }
            if (listener instanceof ContextLoggerExecutionListener) {
                ContextLoggerExecutionListener ctxListener = (ContextLoggerExecutionListener)listener;
                gen = new LogReformatter(logformat, new ContextLoggerExecutionListenerMapGenerator(ctxListener));
            } else {
                HashMap<String, String> baseContext = new HashMap<String, String>();
                baseContext.put("node", node.getNodename());
                baseContext.put("user", node.extractUserName());
                gen = new LogReformatter(logformat, baseContext);
            }
        }
        return gen;
    }

    static class ThreadStreamFormatter {
        final LogReformatter gen;
        private ThreadBoundOutputStream threadBoundSysOut;
        private ThreadBoundOutputStream threadBoundSysErr;
        private OutputStream origout;
        private OutputStream origerr;

        ThreadStreamFormatter(LogReformatter gen) {
            this.gen = gen;
        }

        public ThreadBoundOutputStream getThreadBoundSysOut() {
            return this.threadBoundSysOut;
        }

        public ThreadBoundOutputStream getThreadBoundSysErr() {
            return this.threadBoundSysErr;
        }

        public OutputStream getOrigout() {
            return this.origout;
        }

        public OutputStream getOrigerr() {
            return this.origerr;
        }

        public ThreadStreamFormatter invoke() {
            FormattedOutputStream errformat;
            FormattedOutputStream outformat;
            this.threadBoundSysOut = ThreadBoundOutputStream.bindSystemOut();
            this.threadBoundSysErr = ThreadBoundOutputStream.bindSystemErr();
            this.origout = this.threadBoundSysOut.getThreadStream();
            this.origerr = this.threadBoundSysErr.getThreadStream();
            if (this.origout instanceof FormattedOutputStream) {
                OutputStream origsink = ((FormattedOutputStream)this.origout).getOriginalSink();
                outformat = new FormattedOutputStream(this.gen, origsink);
            } else {
                outformat = new FormattedOutputStream(this.gen, this.origout);
            }
            outformat.setContext("level", "INFO");
            if (this.origerr instanceof FormattedOutputStream) {
                OutputStream origsink = ((FormattedOutputStream)this.origerr).getOriginalSink();
                errformat = new FormattedOutputStream(this.gen, origsink);
            } else {
                errformat = new FormattedOutputStream(this.gen, this.origerr);
            }
            errformat.setContext("level", "ERROR");
            this.threadBoundSysOut.installThreadStream(outformat);
            this.threadBoundSysErr.installThreadStream(errformat);
            return this;
        }

        public void resetOutputStreams() {
            this.threadBoundSysOut.removeThreadStream();
            this.threadBoundSysErr.removeThreadStream();
            if (null != this.origout) {
                this.threadBoundSysOut.installThreadStream(this.origout);
            }
            if (null != this.origerr) {
                this.threadBoundSysErr.installThreadStream(this.origerr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextLoggerExecutionListenerMapGenerator
    implements MapGenerator<String, String> {
        final ContextLoggerExecutionListener ctxListener;

        private ContextLoggerExecutionListenerMapGenerator(ContextLoggerExecutionListener ctxListener) {
            this.ctxListener = ctxListener;
        }

        @Override
        public Map<String, String> getMap() {
            return this.ctxListener.getLoggingContext();
        }
    }
}

