/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.commands;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.commands.CommandInterpreter;
import com.dtolabs.rundeck.core.execution.commands.InterpreterException;
import com.dtolabs.rundeck.core.execution.commands.InterpreterResult;
import com.dtolabs.rundeck.core.execution.commands.ScriptFileCommand;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import java.io.File;

public class ScriptFileCommandInterpreter
implements CommandInterpreter {
    public static final String SERVICE_IMPLEMENTATION_NAME = "script";
    private Framework framework;

    public ScriptFileCommandInterpreter(Framework framework) {
        this.framework = framework;
    }

    public InterpreterResult interpretCommand(ExecutionContext context, ExecutionItem item, INodeEntry node) throws InterpreterException {
        String filepath;
        ScriptFileCommand script = (ScriptFileCommand)item;
        ExecutionService executionService = this.framework.getExecutionService();
        try {
            filepath = null != script.getScript() ? executionService.fileCopyScriptContent(context, script.getScript(), node) : (null != script.getServerScriptFilePath() ? executionService.fileCopyFile(context, new File(script.getServerScriptFilePath()), node) : executionService.fileCopyFileStream(context, script.getScriptAsStream(), node));
        }
        catch (FileCopierException e) {
            throw new InterpreterException(e);
        }
        try {
            NodeExecutorResult nodeExecutorResult;
            if (!"windows".equalsIgnoreCase(node.getOsFamily()) && !(nodeExecutorResult = this.framework.getExecutionService().executeCommand(context, new String[]{"chmod", "+x", filepath}, node)).isSuccess()) {
                return nodeExecutorResult;
            }
            String[] args = script.getArgs();
            String[] newargs = null;
            if (null != args && args.length > 0) {
                newargs = new String[args.length + 1];
                String[] replargs = DataContextUtils.replaceDataReferences(args, context.getDataContext());
                newargs[0] = filepath;
                System.arraycopy(replargs, 0, newargs, 1, replargs.length);
            } else {
                newargs = new String[]{filepath};
            }
            return this.framework.getExecutionService().executeCommand(context, newargs, node);
        }
        catch (ExecutionException e) {
            throw new InterpreterException(e);
        }
    }
}

