/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.commands;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.UpdateUtils;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdater;
import com.dtolabs.rundeck.core.common.impl.URLFileUpdaterBuilder;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.commands.CommandInterpreter;
import com.dtolabs.rundeck.core.execution.commands.InterpreterException;
import com.dtolabs.rundeck.core.execution.commands.InterpreterResult;
import com.dtolabs.rundeck.core.execution.commands.ScriptURLCommandExecutionItem;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.utils.Converter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptURLCommandInterpreter
implements CommandInterpreter {
    public static final Logger logger = Logger.getLogger((String)ScriptURLCommandInterpreter.class.getName());
    public static final String SERVICE_IMPLEMENTATION_NAME = "script-url";
    public static final int DEFAULT_TIMEOUT = 30;
    public static final boolean USE_CACHE = true;
    private File cacheDir;
    private Framework framework;
    URLFileUpdater.httpClientInteraction interaction;
    public static final Converter<String, String> urlPathEncoder = new Converter<String, String>(){

        @Override
        public String convert(String s) {
            try {
                return URIUtil.encodeWithinPath((String)s, (String)"UTF-8");
            }
            catch (URIException e) {
                e.printStackTrace();
                return s;
            }
        }
    };
    public static final Converter<String, String> urlQueryEncoder = new Converter<String, String>(){

        @Override
        public String convert(String s) {
            try {
                return URIUtil.encodeWithinQuery((String)s, (String)"UTF-8");
            }
            catch (URIException e) {
                e.printStackTrace();
                return s;
            }
        }
    };

    public ScriptURLCommandInterpreter(Framework framework) {
        this.framework = framework;
        this.cacheDir = new File(Constants.getBaseVar(framework.getBaseDir().getAbsolutePath()) + "/cache/ScriptURLCommandInterpreter");
    }

    private static String hashURL(String url) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(url.getBytes(Charset.forName("UTF-8")));
            return new String(Hex.encodeHex((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return Integer.toString(url.hashCode());
        }
    }

    @Override
    public InterpreterResult interpretCommand(ExecutionContext context, ExecutionItem item, INodeEntry node) throws InterpreterException {
        String filepath;
        URL url;
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new RuntimeException("Unable to create cachedir: " + this.cacheDir.getAbsolutePath());
        }
        ScriptURLCommandExecutionItem script = (ScriptURLCommandExecutionItem)item;
        ExecutionService executionService = this.framework.getExecutionService();
        Map<String, Map<String, String>> nodeDataContext = DataContextUtils.addContext("node", DataContextUtils.nodeData(node), context.getDataContext());
        String finalUrl = ScriptURLCommandInterpreter.expandUrlString(script.getURLString(), nodeDataContext);
        try {
            url = new URL(finalUrl);
        }
        catch (MalformedURLException e) {
            throw new InterpreterException(e);
        }
        if (null != context.getExecutionListener()) {
            context.getExecutionListener().log(4, "Requesting URL: " + url.toExternalForm());
        }
        String cleanUrl = url.toExternalForm().replaceAll("^(https?://)([^:@/]+):[^@/]*@", "$1$2:****@");
        String tempFileName = ScriptURLCommandInterpreter.hashURL(url.toExternalForm()) + ".temp";
        File destinationTempFile = new File(this.cacheDir, tempFileName);
        File destinationCacheData = new File(this.cacheDir, tempFileName + ".cache.properties");
        URLFileUpdaterBuilder urlFileUpdaterBuilder = new URLFileUpdaterBuilder().setUrl(url).setAcceptHeader("*/*").setTimeout(30);
        urlFileUpdaterBuilder.setCacheMetadataFile(destinationCacheData).setCachedContent(destinationTempFile).setUseCaching(true);
        URLFileUpdater updater = urlFileUpdaterBuilder.createURLFileUpdater();
        try {
            if (null != this.interaction) {
                updater.setInteraction(this.interaction);
            }
            UpdateUtils.update(updater, destinationTempFile);
            logger.debug((Object)("Updated nodes resources file: " + destinationTempFile));
        }
        catch (UpdateUtils.UpdateException e) {
            if (!destinationTempFile.isFile() || destinationTempFile.length() < 1L) {
                throw new InterpreterException("Error requesting URL Script: " + cleanUrl + ": " + e.getMessage(), e);
            }
            logger.error((Object)("Error requesting URL script: " + cleanUrl + ": " + e.getMessage()), (Throwable)e);
        }
        try {
            filepath = executionService.fileCopyFile(context, destinationTempFile, node);
        }
        catch (FileCopierException e) {
            throw new InterpreterException(e);
        }
        try {
            NodeExecutorResult nodeExecutorResult;
            if (!"windows".equalsIgnoreCase(node.getOsFamily()) && !(nodeExecutorResult = this.framework.getExecutionService().executeCommand(context, new String[]{"chmod", "+x", filepath}, node)).isSuccess()) {
                return nodeExecutorResult;
            }
            String[] args = script.getArgs();
            String[] newargs = null;
            if (null != args && args.length > 0) {
                newargs = new String[args.length + 1];
                String[] replargs = DataContextUtils.replaceDataReferences(args, nodeDataContext);
                newargs[0] = filepath;
                System.arraycopy(replargs, 0, newargs, 1, replargs.length);
            } else {
                newargs = new String[]{filepath};
            }
            return this.framework.getExecutionService().executeCommand(context, newargs, node);
        }
        catch (ExecutionException e) {
            throw new InterpreterException(e);
        }
    }

    public static String expandUrlString(String urlString, Map<String, Map<String, String>> dataContext) {
        String origUrl = urlString;
        int qindex = origUrl.indexOf("?");
        StringBuilder builder = new StringBuilder();
        if (qindex > 0) {
            builder.append(DataContextUtils.replaceDataReferences(origUrl.substring(0, qindex), dataContext, urlPathEncoder, true));
            builder.append("?");
            if (qindex < origUrl.length() - 1) {
                builder.append(DataContextUtils.replaceDataReferences(origUrl.substring(qindex + 1), dataContext, urlQueryEncoder, true));
            }
            return builder.toString();
        }
        return DataContextUtils.replaceDataReferences(urlString, dataContext, urlPathEncoder, false);
    }

    URLFileUpdater.httpClientInteraction getInteraction() {
        return this.interaction;
    }

    void setInteraction(URLFileUpdater.httpClientInteraction interaction) {
        this.interaction = interaction;
    }
}

