/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.INodeEntry;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INodeEntryComparator
implements Comparator<INodeEntry> {
    private final String rankProperty;

    public INodeEntryComparator(String rankProperty) {
        this.rankProperty = rankProperty;
    }

    @Override
    public int compare(INodeEntry iNodeEntry, INodeEntry iNodeEntryB) {
        String valB;
        String valA;
        if (null != this.rankProperty) {
            valA = iNodeEntry.getAttributes().get(this.rankProperty);
            valB = iNodeEntryB.getAttributes().get(this.rankProperty);
        } else {
            valA = iNodeEntry.getNodename();
            valB = iNodeEntryB.getNodename();
        }
        if (null != valA && null != valB) {
            int i;
            Long numA = null;
            Long numB = null;
            try {
                numA = Long.parseLong(valA);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                numB = Long.parseLong(valB);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (null != numA && null != numB && 0 != (i = numA.compareTo(numB))) {
                return i;
            }
            return valA.compareTo(valB);
        }
        if (null != valA) {
            return -1;
        }
        if (null != valB) {
            return 1;
        }
        return iNodeEntry.getNodename().compareTo(iNodeEntryB.getNodename());
    }
}

