/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeFilter;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.ParallelNodeDispatcher;
import com.dtolabs.rundeck.core.execution.dispatch.SequentialNodeDispatcher;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.plugins.BaseProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDispatcherService
extends BaseProviderRegistryService<NodeDispatcher> {
    private static final String SERVICE_NAME = "NodeDispatcher";

    public NodeDispatcherService(Framework framework) {
        super(framework);
        this.registry.put("parallel", ParallelNodeDispatcher.class);
        this.registry.put("sequential", SequentialNodeDispatcher.class);
    }

    public NodeDispatcher getNodeDispatcher(ExecutionContext context) throws ExecutionServiceException {
        NodesSelector nodeset = context.getNodeSelector();
        FrameworkProject frameworkProject = this.framework.getFrameworkProjectMgr().getFrameworkProject(context.getFrameworkProject());
        INodeSet filtered = null;
        try {
            INodeSet unfiltered = null != context.getNodesFile() ? FileResourceModelSource.parseFile(context.getNodesFile(), this.framework, context.getFrameworkProject()) : frameworkProject.getNodeSet();
            filtered = NodeFilter.filterNodes(nodeset, unfiltered);
        }
        catch (NodeFileParserException e) {
            throw new ExecutionServiceException(e, this.getName());
        }
        catch (ResourceModelSourceException e) {
            throw new ExecutionServiceException(e, this.getName());
        }
        catch (ConfigurationException e) {
            throw new ExecutionServiceException(e, this.getName());
        }
        if (context.getThreadCount() > 1 && filtered.getNodeNames().size() > 1) {
            return (NodeDispatcher)this.providerOfType("parallel");
        }
        return (NodeDispatcher)this.providerOfType("sequential");
    }

    public static NodeDispatcherService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            NodeDispatcherService service = new NodeDispatcherService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (NodeDispatcherService)framework.getService(SERVICE_NAME);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }
}

