/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.dispatch;

import com.dtolabs.rundeck.core.NodesetFailureException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionServiceThread;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.dispatch.INodeEntryComparator;
import com.dtolabs.rundeck.core.execution.dispatch.NodeDispatcher;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;

public class SequentialNodeDispatcher
implements NodeDispatcher {
    private Framework framework;

    public SequentialNodeDispatcher(Framework framework) {
        this.framework = framework;
    }

    public DispatcherResult dispatch(ExecutionContext context, ExecutionItem item) throws DispatcherException {
        return this.dispatch(context, item, null);
    }

    public DispatcherResult dispatch(ExecutionContext context, Dispatchable item) throws DispatcherException {
        return this.dispatch(context, null, item);
    }

    public DispatcherResult dispatch(ExecutionContext context, ExecutionItem item, Dispatchable toDispatch) throws DispatcherException {
        NodesSelector nodesSelector = context.getNodeSelector();
        INodeSet nodes = null;
        try {
            nodes = this.framework.filterAuthorizedNodes(context.getFrameworkProject(), new HashSet<String>(Arrays.asList("read", "run")), this.framework.filterNodeSet(nodesSelector, context.getFrameworkProject(), context.getNodesFile()));
        }
        catch (NodeFileParserException e) {
            throw new DispatcherException(e);
        }
        if (nodes.getNodes().size() < 1) {
            throw new DispatcherException("No nodes matched");
        }
        boolean keepgoing = context.isKeepgoing();
        context.getExecutionListener().log(4, "preparing for sequential execution on " + nodes.getNodes().size() + " nodes");
        HashSet<String> nodeNames = new HashSet<String>(nodes.getNodeNames());
        HashMap<String, Object> failures = new HashMap<String, Object>();
        FailedNodesListener failedListener = context.getExecutionListener().getFailedNodesListener();
        if (null != failedListener) {
            failedListener.matchedNodes(nodeNames);
        }
        boolean interrupted = false;
        Thread thread = Thread.currentThread();
        boolean success = true;
        final HashMap<String, StatusResult> resultMap = new HashMap<String, StatusResult>();
        Collection<INodeEntry> nodes1 = nodes.getNodes();
        String rankProperty = null != context.getNodeRankAttribute() ? context.getNodeRankAttribute() : "nodename";
        boolean rankAscending = context.isNodeRankOrderAscending();
        INodeEntryComparator comparator = new INodeEntryComparator(rankProperty);
        TreeSet<INodeEntry> orderedNodes = new TreeSet<INodeEntry>(rankAscending ? comparator : Collections.reverseOrder(comparator));
        orderedNodes.addAll(nodes1);
        Throwable caught = null;
        INodeEntry failedNode = null;
        for (INodeEntry node1 : orderedNodes) {
            if (thread.isInterrupted() || thread instanceof ExecutionServiceThread && ((ExecutionServiceThread)thread).isAborted()) {
                interrupted = true;
                break;
            }
            INodeEntry node = node1;
            context.getExecutionListener().log(4, "Executing command on node: " + node.getNodename() + ", " + node.toString());
            try {
                if (thread.isInterrupted() || thread instanceof ExecutionServiceThread && ((ExecutionServiceThread)thread).isAborted()) {
                    interrupted = true;
                    break;
                }
                ExecutionContextImpl interimcontext = new ExecutionContextImpl.Builder(context).nodeSelector(SelectorUtils.singleNode(node.getNodename())).build();
                StatusResult result = null != item ? this.framework.getExecutionService().interpretCommand(interimcontext, item, node) : toDispatch.dispatch(interimcontext, node);
                if (null != result) {
                    resultMap.put(node.getNodename(), result);
                }
                if (null == result || !result.isSuccess()) {
                    success = false;
                    if (null != result) {
                        failures.put(node.getNodename(), result);
                    } else {
                        failures.put(node.getNodename(), "Failed execution, result was null");
                    }
                    if (keepgoing) continue;
                    failedNode = node;
                    break;
                }
                nodeNames.remove(node.getNodename());
            }
            catch (Throwable e) {
                success = false;
                failures.put(node.getNodename(), "Error dispatching command to the node: " + e.getMessage());
                context.getExecutionListener().log(0, "Failed dispatching to node " + node.getNodename() + ": " + e.getMessage());
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                context.getExecutionListener().log(4, "Failed dispatching to node " + node.getNodename() + ": " + stringWriter.toString());
                if (keepgoing) continue;
                failedNode = node;
                caught = e;
                break;
            }
        }
        if (!keepgoing && failures.size() > 0 && null != failedListener) {
            failedListener.nodesFailed(failures);
        }
        if (!keepgoing && null != caught) {
            throw new DispatcherException("Failed dispatching to node " + failedNode.getNodename() + ": " + caught.getMessage(), caught, failedNode);
        }
        if (keepgoing && nodeNames.size() > 0) {
            if (null != failedListener) {
                failedListener.nodesFailed(failures);
            }
            throw new NodesetFailureException(failures);
        }
        if (null != failedListener && failures.isEmpty() && !interrupted) {
            failedListener.nodesSucceeded();
        }
        if (interrupted) {
            throw new DispatcherException("Node dispatch interrupted");
        }
        final boolean status = success;
        return new DispatcherResult(){

            @Override
            public Map<String, ? extends StatusResult> getResults() {
                return resultMap;
            }

            @Override
            public boolean isSuccess() {
                return status;
            }

            public String toString() {
                return "DispatcherResult{status=" + this.isSuccess() + ", " + "results=" + this.getResults() + "}";
            }
        };
    }
}

