/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.jsch;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.impl.jsch.JschNodeExecutor;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.tasks.net.SSHTaskBuilder;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;

public class JschScpFileCopier
extends BaseFileCopier
implements FileCopier,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "jsch-scp";
    static final Description DESC = new Description(){

        @Override
        public String getName() {
            return JschScpFileCopier.SERVICE_PROVIDER_TYPE;
        }

        @Override
        public String getTitle() {
            return "SCP";
        }

        @Override
        public String getDescription() {
            return "Copies a script file to a remote node via SCP.";
        }

        @Override
        public List<Property> getProperties() {
            return JschNodeExecutor.CONFIG_PROPERTIES;
        }

        @Override
        public Map<String, String> getPropertiesMapping() {
            return JschNodeExecutor.CONFIG_MAPPING;
        }
    };
    private Framework framework;

    public Description getDescription() {
        return DESC;
    }

    public JschScpFileCopier(Framework framework) {
        this.framework = framework;
    }

    public String copyFileStream(ExecutionContext context, InputStream input, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, input, null, node);
    }

    public String copyFile(ExecutionContext context, File scriptfile, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, scriptfile, null, null, node);
    }

    public String copyScriptContent(ExecutionContext context, String script, INodeEntry node) throws FileCopierException {
        return this.copyFile(context, null, null, script, node);
    }

    private String copyFile(ExecutionContext context, File scriptfile, InputStream input, String script, INodeEntry node) throws FileCopierException {
        Scp scp;
        Project project = new Project();
        Sequential seq = new Sequential();
        seq.setProject(project);
        String remotefile = JschScpFileCopier.generateRemoteFilepathForNode(node, null != scriptfile ? scriptfile.getName() : "dispatch-script");
        File localTempfile = JschScpFileCopier.writeScriptTempFile(context, scriptfile, input, script, node);
        JschNodeExecutor.NodeSSHConnectionInfo nodeAuthentication = new JschNodeExecutor.NodeSSHConnectionInfo(node, this.framework, context);
        try {
            scp = SSHTaskBuilder.buildScp(node, project, remotefile, localTempfile, nodeAuthentication, context.getLoglevel());
        }
        catch (SSHTaskBuilder.BuilderException e) {
            throw new FileCopierException(e);
        }
        seq.addTask((Task)this.createEchoVerbose("copying scriptfile: '" + localTempfile.getAbsolutePath() + "' to: '" + node.getNodename() + ":" + remotefile + "'", project));
        seq.addTask((Task)scp);
        String errormsg = null;
        try {
            seq.execute();
        }
        catch (BuildException e) {
            if (null != e.getCause() && e.getCause() instanceof JSchException && e.getCause().getMessage().contains("Auth cancel")) {
                String msgformat = "Authentication failure connecting to node: \"{0}\". Make sure your resource definitions and credentials are up to date.";
                if (this.framework.getPropertyLookup().hasProperty("framework.messages.error.ssh.authcancel")) {
                    msgformat = this.framework.getProperty("framework.messages.error.ssh.authcancel");
                }
                errormsg = MessageFormat.format(msgformat, node.getNodename(), e.getMessage());
            } else {
                errormsg = e.getMessage();
            }
            context.getExecutionListener().log(0, errormsg);
            throw new FileCopierException("[jsch-scp] Failed copying the file: " + errormsg, (Exception)((Object)e));
        }
        if (!localTempfile.delete()) {
            context.getExecutionListener().log(1, "Unable to remove local temp file: " + localTempfile.getAbsolutePath());
        }
        return remotefile;
    }

    private Echo createEcho(String message, Project project, String logLevel) {
        Echo echo = new Echo();
        echo.setProject(project);
        Echo.EchoLevel level = new Echo.EchoLevel();
        level.setValue(logLevel);
        echo.setLevel(level);
        echo.setMessage(message);
        return echo;
    }

    private Echo createEchoVerbose(String message, Project project) {
        return this.createEcho(message, project, "debug");
    }
}

