/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.impl.local;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.impl.common.AntSupport;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGenerator;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGeneratorImpl;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameters;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalNodeExecutor
implements NodeExecutor {
    public static final String SERVICE_PROVIDER_TYPE = "local";
    private Framework framework;
    private ExecTaskParameterGenerator parameterGenerator;

    public LocalNodeExecutor(Framework framework) {
        this.framework = framework;
        this.parameterGenerator = new ExecTaskParameterGeneratorImpl();
    }

    @Override
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) throws ExecutionException {
        int result;
        ExecutionListener listener = context.getExecutionListener();
        Project project = new Project();
        AntSupport.addAntBuildListener(listener, project);
        String propName = System.currentTimeMillis() + ".node." + node.getNodename() + ".LocalNodeExecutor.result";
        boolean success = false;
        ExecTask execTask = this.buildExecTask(project, this.parameterGenerator.generate(node, true, null, command), context.getDataContext());
        execTask.setResultProperty(propName);
        try {
            execTask.execute();
            success = true;
        }
        catch (BuildException e) {
            context.getExecutionListener().log(0, e.getMessage());
        }
        int n = result = success ? 0 : -1;
        if (project.getProperty(propName) != null) {
            try {
                result = Integer.parseInt(project.getProperty(propName));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        final boolean status = 0 == result;
        final int resultCode = result;
        return new NodeExecutorResult(){

            public int getResultCode() {
                return resultCode;
            }

            public boolean isSuccess() {
                return status;
            }

            public String toString() {
                return "[local node exec] result was " + (this.isSuccess() ? "success" : "failure") + ", resultcode: " + this.getResultCode();
            }
        };
    }

    private ExecTask buildExecTask(Project project, ExecTaskParameters taskParameters, Map<String, Map<String, String>> dataContext) {
        ExecTask execTask = new ExecTask();
        execTask.setTaskType("exec");
        execTask.setFailonerror(false);
        execTask.setProject(project);
        Commandline.Argument arg = execTask.createArg();
        execTask.setExecutable(taskParameters.getCommandexecutable());
        arg.setLine(taskParameters.getCommandargline());
        DataContextUtils.addEnvVarsFromContextForExec(execTask, dataContext);
        return execTask;
    }
}

