/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.script;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameterGenerator;
import com.dtolabs.rundeck.core.execution.script.ExecTaskParameters;
import java.io.File;

public class ExecTaskParameterGeneratorImpl
implements ExecTaskParameterGenerator {
    public ExecTaskParameters generate(INodeEntry nodeentry, boolean command, File scriptfile, String[] args) throws ExecutionException {
        String commandargline;
        String commandexecutable;
        if (!command && null == scriptfile) {
            throw new ExecutionException("Could not determine the command to dispatch");
        }
        if ("windows".equals(nodeentry.getOsFamily())) {
            String commandString;
            if (command) {
                commandString = CLIUtils.generateArgline(null, args);
            } else if (null != scriptfile) {
                commandString = CLIUtils.generateArgline(scriptfile.getAbsolutePath(), args);
            } else {
                throw new ExecutionException("Could not determine the command to dispatch");
            }
            commandexecutable = "cmd.exe";
            String argline = commandString.indexOf("\"") >= 0 ? "/c " + commandString : (commandString.indexOf(" ") >= 0 ? "/c \"" + commandString + "\"" : "/c " + commandString);
            commandargline = argline;
        } else if (command) {
            commandexecutable = "/bin/sh";
            String commandString = CLIUtils.generateArgline(null, args);
            commandargline = "-c " + (commandString.contains("\"") ? "'" + commandString + "'" : "\"" + commandString + "\"");
        } else if (null != scriptfile) {
            String scriptPath;
            commandexecutable = scriptPath = scriptfile.getAbsolutePath();
            commandargline = CLIUtils.generateArgline(null, args);
        } else {
            throw new ExecutionException("Could not determine the command to dispatch");
        }
        return new ExecTaskParameters(){

            public String getCommandexecutable() {
                return commandexecutable;
            }

            public String getCommandargline() {
                return commandargline;
            }
        };
    }
}

